"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleLastRunOutcomeFilter = void 0;
Object.defineProperty(exports, "getHealthColor", {
  enumerable: true,
  get: function () {
    return _lib.getOutcomeHealthColor;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _translations = require("../translations");
var _lib = require("../../../../common/lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortedRuleLastRunOutcomeValues = [..._common.RuleLastRunOutcomeValues].sort();
const RuleLastRunOutcomeFilter = ({
  selectedOutcomes,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onTogglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  }, [setIsPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const onFilterSelectItem = (0, _react.useCallback)(filterItem => () => {
    const isPreviouslyChecked = selectedOutcomes.includes(filterItem);
    if (isPreviouslyChecked) {
      onChange === null || onChange === void 0 ? void 0 : onChange(selectedOutcomes.filter(val => val !== filterItem));
    } else {
      onChange === null || onChange === void 0 ? void 0 : onChange(selectedOutcomes.concat(filterItem));
    }
  }, [onChange, selectedOutcomes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      hasActiveFilters: selectedOutcomes.length > 0,
      numActiveFilters: selectedOutcomes.length,
      numFilters: selectedOutcomes.length,
      onClick: onTogglePopover,
      "data-test-subj": "ruleLastRunOutcomeFilterButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.ruleLastRunOutcomeFilterLabel",
      defaultMessage: "Last response"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, sortedRuleLastRunOutcomeValues.map(item => {
    const healthColor = (0, _lib.getOutcomeHealthColor)(item);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: item,
      style: {
        textTransform: 'capitalize'
      },
      onClick: onFilterSelectItem(item),
      checked: selectedOutcomes.includes(item) ? 'on' : undefined,
      "data-test-subj": `ruleLastRunOutcome${item}FilterOption`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: healthColor
    }, _translations.rulesLastRunOutcomeTranslationMapping[item]));
  })));
};
exports.RuleLastRunOutcomeFilter = RuleLastRunOutcomeFilter;