"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsedItemActionsWithApi = exports.CollapsedItemActions = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _lib = require("../../../lib");
require("./collapsed_item_actions.scss");
var _rule_snooze = require("./rule_snooze");
var _notify_badge = require("./notify_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CollapsedItemActions = ({
  item,
  onLoading,
  onRuleChanged,
  bulkDisableRules,
  bulkEnableRules,
  onDeleteRule,
  onEditRule,
  onUpdateAPIKey,
  snoozeRule,
  unsnoozeRule,
  onRunRule,
  onCloneRule
}) => {
  var _item$snoozeSchedule, _item$activeSnoozes;
  const {
    ruleTypeRegistry,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isDisabled, setIsDisabled] = (0, _react.useState)(!item.enabled);
  (0, _react.useEffect)(() => {
    setIsDisabled(!item.enabled);
  }, [item.enabled]);
  const onClose = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const snoozeRuleInternal = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      onLoading(true);
      await snoozeRule(item, snoozeSchedule);
      await onRuleChanged();
      toasts.addSuccess(_notify_badge.SNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
      onClose();
    }
    await snoozeRule(item, snoozeSchedule);
  }, [onLoading, snoozeRule, item, onRuleChanged, toasts, onClose]);
  const unsnoozeRuleInternal = (0, _react.useCallback)(async scheduleIds => {
    try {
      onLoading(true);
      await unsnoozeRule(item, scheduleIds);
      await onRuleChanged();
      toasts.addSuccess(_notify_badge.UNSNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_notify_badge.SNOOZE_FAILED_MESSAGE);
    } finally {
      onLoading(false);
      onClose();
    }
  }, [onLoading, unsnoozeRule, item, onRuleChanged, toasts, onClose]);
  const isRuleTypeEditableInContext = ruleTypeRegistry.has(item.ruleTypeId) ? !ruleTypeRegistry.get(item.ruleTypeId).requiresAppContext : false;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    disabled: !item.isEditable,
    "data-test-subj": "selectActionButton",
    "data-testid": "selectActionButton",
    iconType: "boxesHorizontal",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.popoverButtonTitle', {
      defaultMessage: 'Actions'
    })
  });
  const isSnoozed = (0, _react.useMemo)(() => {
    return (0, _lib.isRuleSnoozed)(item);
  }, [item]);
  const snoozedButtonText = (0, _react.useMemo)(() => {
    if (item.muteAll) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snoozedIndefinitely', {
        defaultMessage: 'Snoozed indefinitely'
      });
    }
    if (isSnoozed) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snoozedUntil', {
        defaultMessage: 'Snoozed until {snoozeTime}',
        values: {
          snoozeTime: (0, _moment.default)(item.isSnoozedUntil).format('MMM D')
        }
      });
    }
    return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.snooze', {
      defaultMessage: 'Snooze'
    });
  }, [isSnoozed, item]);
  const snoozePanelItem = (0, _react.useMemo)(() => {
    if (isDisabled || item.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
      return [];
    }
    return [{
      disabled: !item.isEditable || !item.enabledInLicense,
      'data-test-subj': 'snoozeButton',
      icon: 'bellSlash',
      name: snoozedButtonText,
      panel: 1
    }];
  }, [isDisabled, item, snoozedButtonText]);
  const panels = [{
    id: 0,
    hasFocus: false,
    items: [...snoozePanelItem, {
      isSeparator: true
    }, {
      disabled: !item.isEditable || !item.enabledInLicense,
      'data-test-subj': 'disableButton',
      onClick: async () => {
        const enabled = !isDisabled;
        _rxjs.asyncScheduler.schedule(async () => {
          if (enabled) {
            await bulkDisableRules({
              ids: [item.id]
            });
          } else {
            await bulkEnableRules({
              ids: [item.id]
            });
          }
          onRuleChanged();
        }, 10);
        setIsDisabled(!isDisabled);
        setIsPopoverOpen(!isPopoverOpen);
      },
      name: isDisabled ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.enableTitle', {
        defaultMessage: 'Enable'
      }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.disableTitle', {
        defaultMessage: 'Disable'
      })
    }, {
      disabled: !item.isEditable || item.consumer === _ruleDataUtils.AlertConsumers.SIEM,
      'data-test-subj': 'cloneRule',
      onClick: async () => {
        setIsPopoverOpen(!isPopoverOpen);
        onCloneRule(item.id);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.cloneRuleTitle', {
        defaultMessage: 'Clone rule'
      })
    }, {
      disabled: !item.isEditable || !isRuleTypeEditableInContext,
      'data-test-subj': 'editRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onEditRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.editTitle', {
        defaultMessage: 'Edit rule'
      })
    }, {
      disabled: !item.isEditable,
      'data-test-subj': 'updateApiKey',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onUpdateAPIKey(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.updateApiKey', {
        defaultMessage: 'Update API key'
      })
    }, {
      disabled: !item.isEditable,
      'data-test-subj': 'runRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onRunRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActions.runRule', {
        defaultMessage: 'Run rule'
      })
    }, {
      disabled: !item.isEditable,
      className: 'collapsedItemActions__deleteButton',
      'data-test-subj': 'deleteRule',
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
        onDeleteRule(item);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.deleteRuleTitle', {
        defaultMessage: 'Delete rule'
      })
    }]
  }, {
    id: 1,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "bellSlash"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.collapsedItemActons.snoozeActions', {
      defaultMessage: 'Snooze notifications'
    }))),
    width: 500,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
      interval: (0, _rule_snooze.futureTimeToInterval)(item.isSnoozedUntil),
      hasTitle: false,
      scheduledSnoozes: (_item$snoozeSchedule = item.snoozeSchedule) !== null && _item$snoozeSchedule !== void 0 ? _item$snoozeSchedule : [],
      activeSnoozes: (_item$activeSnoozes = item.activeSnoozes) !== null && _item$activeSnoozes !== void 0 ? _item$activeSnoozes : [],
      showCancel: (0, _lib.isRuleSnoozed)(item),
      snoozeRule: snoozeRuleInternal,
      unsnoozeRule: unsnoozeRuleInternal
    }))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    ownFocus: true,
    panelPaddingSize: "none",
    "data-test-subj": "collapsedItemActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    className: "actCollapsedItemActions",
    "data-test-subj": "collapsedActionPanel",
    "data-testid": "collapsedActionPanel"
  }));
};
exports.CollapsedItemActions = CollapsedItemActions;
const CollapsedItemActionsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(CollapsedItemActions);
exports.CollapsedItemActionsWithApi = CollapsedItemActionsWithApi;