"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionErrorLogFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rule_error_log = require("./rule_error_log");
var _rule_action_error_badge = require("./rule_action_error_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleActionErrorLogFlyout = props => {
  const {
    runLog,
    refreshToken,
    onClose,
    activeSpaceId
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    id,
    rule_id: ruleId,
    message,
    num_errored_actions: totalErrors,
    space_ids: spaceIds = []
  } = runLog;
  const isFlyoutPush = (0, _eui.useIsWithinBreakpoints)(['xl']);
  const logFromDifferentSpace = (0, _react.useMemo)(() => Boolean(activeSpaceId && !(spaceIds !== null && spaceIds !== void 0 && spaceIds.includes(activeSpaceId))), [activeSpaceId, spaceIds]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: isFlyoutPush ? 'push' : 'overlay',
    onClose: onClose,
    size: isFlyoutPush ? 'm' : 'l',
    "data-test-subj": "ruleActionErrorLogFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.ruleActionErrorLogFlyout.actionErrors",
    defaultMessage: "Errored Actions"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      fontWeight: euiTheme.font.weight.bold
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.ruleActionErrorLogFlyout.message",
    defaultMessage: "Message"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "ruleActionErrorLogFlyoutMessageText"
  }, message), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_rule_action_error_badge.RuleActionErrorBadge, {
    totalErrors: totalErrors
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.ruleActionErrorLogFlyout.actionErrorsPlural",
    defaultMessage: "{value, plural, one {errored action} other {errored actions}}",
    values: {
      value: totalErrors
    }
  })), /*#__PURE__*/_react.default.createElement(_rule_error_log.RuleErrorLogWithApi, {
    ruleId: ruleId,
    runId: id,
    spaceId: spaceIds[0],
    logFromDifferentSpace: logFromDifferentSpace,
    refreshToken: refreshToken
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "ruleActionErrorLogFlyoutCloseButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.ruleActionErrorLogFlyout.close",
    defaultMessage: "Close"
  }))));
};
exports.RuleActionErrorLogFlyout = RuleActionErrorLogFlyout;