"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogPaginationStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventLogPaginationStatus = props => {
  const {
    pageIndex,
    pageSize,
    totalItemCount
  } = props;
  const paginationStatusRange = (0, _react.useMemo)(() => {
    if (totalItemCount === 0) {
      return /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.eventLogPaginationStatus.paginationResultsRangeNoResult",
        defaultMessage: "0"
      }));
    }
    const end = Math.min(pageSize * (pageIndex + 1), totalItemCount);
    return /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.eventLogPaginationStatus.paginationResultsRange",
      defaultMessage: "{start, number} - {end, number}",
      values: {
        start: pageIndex * pageSize + 1,
        end
      }
    }));
  }, [pageSize, pageIndex, totalItemCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "eventLogPaginationStatus",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.eventLogPaginationStatus.paginationResults",
    defaultMessage: "Showing {range} of {total, number} {type}",
    values: {
      range: paginationStatusRange,
      total: totalItemCount,
      type: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.eventLogPaginationStatus.paginationResultsType",
        defaultMessage: "log {total, plural, one {entry} other {entries}}",
        values: {
          total: totalItemCount
        }
      }))
    }
  }));
};
exports.EventLogPaginationStatus = EventLogPaginationStatus;