"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numTriggeredActionsDisplay = exports.numSucceededActionsDisplay = exports.numGeneratedActionsDisplay = exports.numErroredActionsDisplay = exports.getIsColumnSortable = exports.EventLogDataGrid = exports.ColumnHeaderWithToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _lodash = require("lodash");
var _get_experimental_features = require("../../../../../common/get_experimental_features");
var _ = require(".");
var _rule_action_error_badge = require("../../../rule_details/components/rule_action_error_badge");
require("./event_log_list.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIsColumnSortable = columnId => {
  return _common.executionLogSortableColumns.includes(columnId);
};
exports.getIsColumnSortable = getIsColumnSortable;
const getErroredActionsTranslation = errors => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogDataGrid.erroredActionsTooltip', {
    defaultMessage: '{value, plural, one {# errored action} other {# errored actions}}',
    values: {
      value: errors
    }
  });
};
const PAGE_SIZE_OPTIONS = [10, 50, 100];
const numTriggeredActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.triggeredActions', {
  defaultMessage: 'Triggered actions'
});
exports.numTriggeredActionsDisplay = numTriggeredActionsDisplay;
const numTriggeredActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.triggeredActionsToolTip', {
  defaultMessage: 'The subset of generated actions that will run.'
});
const numGeneratedActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.scheduledActions', {
  defaultMessage: 'Generated actions'
});
exports.numGeneratedActionsDisplay = numGeneratedActionsDisplay;
const numGeneratedActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.scheduledActionsToolTip', {
  defaultMessage: 'The total number of actions generated when the rule ran.'
});
const numSucceededActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.succeededActions', {
  defaultMessage: 'Succeeded actions'
});
exports.numSucceededActionsDisplay = numSucceededActionsDisplay;
const numSucceededActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.succeededActionsToolTip', {
  defaultMessage: 'The number of actions that were completed successfully.'
});
const numErroredActionsDisplay = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.erroredActions', {
  defaultMessage: 'Errored actions'
});
exports.numErroredActionsDisplay = numErroredActionsDisplay;
const numErroredActionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.erroredActionsToolTip', {
  defaultMessage: 'The number of failed actions.'
});
const columnsWithToolTipMap = {
  num_triggered_actions: {
    display: numTriggeredActionsDisplay,
    toolTip: numTriggeredActionsToolTip
  },
  num_generated_actions: {
    display: numGeneratedActionsDisplay,
    toolTip: numGeneratedActionsToolTip
  },
  num_succeeded_actions: {
    display: numSucceededActionsDisplay,
    toolTip: numSucceededActionsToolTip
  },
  num_errored_actions: {
    display: numErroredActionsDisplay,
    toolTip: numErroredActionsToolTip
  }
};
const ColumnHeaderWithToolTip = ({
  id
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: columnsWithToolTipMap[id].toolTip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, columnsWithToolTipMap[id].display), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))));
};
exports.ColumnHeaderWithToolTip = ColumnHeaderWithToolTip;
const EventLogDataGrid = props => {
  const {
    columns,
    logs = [],
    sortingColumns,
    pageSizeOptions = PAGE_SIZE_OPTIONS,
    pagination,
    dateFormat,
    visibleColumns,
    selectedRunLog,
    setVisibleColumns,
    setSortingColumns,
    onChangeItemsPerPage,
    onChangePage,
    onFlyoutOpen,
    getRuleDetailsRoute
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const getPaginatedRowIndex = (0, _react.useCallback)(rowIndex => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return rowIndex - pageIndex * pageSize;
  }, [pagination]);
  const columnVisibilityProps = (0, _react.useMemo)(() => {
    return {
      visibleColumns,
      setVisibleColumns
    };
  }, [visibleColumns, setVisibleColumns]);
  const sortingProps = (0, _react.useMemo)(() => ({
    onSort: setSortingColumns,
    columns: sortingColumns
  }), [setSortingColumns, sortingColumns]);
  const paginationProps = (0, _react.useMemo)(() => ({
    ...pagination,
    pageSizeOptions,
    onChangeItemsPerPage,
    onChangePage
  }), [pagination, pageSizeOptions, onChangeItemsPerPage, onChangePage]);
  const rowClasses = (0, _react.useMemo)(() => {
    if (!selectedRunLog) {
      return {};
    }
    const index = logs.findIndex(log => log.id === selectedRunLog.id);
    return {
      [index]: 'ruleEventLogDataGrid--rowClassSelected'
    };
  }, [selectedRunLog, logs]);
  const gridStyles = (0, _react.useMemo)(() => {
    return {
      border: 'horizontal',
      header: 'underline',
      rowClasses
    };
  }, [rowClasses]);
  const renderMessageWithActionError = (columnId, errors, showTooltip = false) => {
    if (columnId !== 'message') {
      return null;
    }
    if (!errors) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: getErroredActionsTranslation(errors)
    }, /*#__PURE__*/_react.default.createElement(_rule_action_error_badge.RuleActionErrorBadge, {
      totalErrors: errors,
      showIcon: true
    })) : /*#__PURE__*/_react.default.createElement(_rule_action_error_badge.RuleActionErrorBadge, {
      totalErrors: errors,
      showIcon: true
    }));
  };

  // Renders the cell popover for runs with errored actions
  const renderCellPopover = cellPopoverProps => {
    const {
      columnId,
      rowIndex,
      cellActions,
      DefaultCellPopover
    } = cellPopoverProps;
    if (columnId !== 'message') {
      return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, cellPopoverProps);
    }
    const pagedRowIndex = getPaginatedRowIndex(rowIndex);
    const runLog = logs[pagedRowIndex];
    if (!runLog) {
      return null;
    }
    const value = runLog[columnId];
    const actionErrors = (0, _lodash.get)(runLog, 'num_errored_actions', 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), actionErrors > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, renderMessageWithActionError(columnId, actionErrors)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.eventLogDataGrid.erroredActionsCellPopover",
      defaultMessage: "{value, plural, one {errored action} other {errored actions}}",
      values: {
        value: actionErrors
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), cellActions));
  };

  // Main cell renderer, renders durations, statuses, etc.
  const renderCell = ({
    rowIndex,
    columnId
  }) => {
    var _logs$pagedRowIndex, _logs$pagedRowIndex2;
    const pagedRowIndex = getPaginatedRowIndex(rowIndex);
    const runLog = logs[pagedRowIndex];
    const value = (_logs$pagedRowIndex = logs[pagedRowIndex]) === null || _logs$pagedRowIndex === void 0 ? void 0 : _logs$pagedRowIndex[columnId];
    const actionErrors = (0, _lodash.get)(logs[pagedRowIndex], 'num_errored_actions', 0);
    const version = logs === null || logs === void 0 ? void 0 : (_logs$pagedRowIndex2 = logs[pagedRowIndex]) === null || _logs$pagedRowIndex2 === void 0 ? void 0 : _logs$pagedRowIndex2.version;
    const ruleId = (0, _lodash.get)(runLog, 'rule_id');
    const spaceIds = runLog === null || runLog === void 0 ? void 0 : runLog.space_ids;
    if (columnId === 'num_errored_actions' && runLog && onFlyoutOpen) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": "eventLogDataGridErroredActionBadge",
        style: {
          cursor: 'pointer',
          borderRadius: euiTheme.border.radius.medium
        },
        color: "hollow",
        onClick: () => onFlyoutOpen(runLog),
        onClickAriaLabel: _i18n.i18n.translate('xpack.triggersActionsUI.sections.eventLogColumn.openActionErrorsFlyout', {
          defaultMessage: 'Open action errors flyout'
        })
      }, value);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, renderMessageWithActionError(columnId, actionErrors, true), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.EventLogListCellRenderer, {
      columnId: columnId,
      value: value,
      version: version,
      dateFormat: dateFormat,
      ruleId: ruleId,
      spaceIds: spaceIds,
      useExecutionStatus: isRuleUsingExecutionStatus,
      getRuleDetailsRoute: getRuleDetailsRoute
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.EventLogPaginationStatus, {
    pageIndex: pagination.pageIndex,
    pageSize: pagination.pageSize,
    totalItemCount: pagination.totalItemCount
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": "event log",
    "data-test-subj": "eventLogList",
    columns: columns,
    rowCount: pagination.totalItemCount,
    renderCellValue: renderCell,
    columnVisibility: columnVisibilityProps,
    sorting: sortingProps,
    pagination: paginationProps,
    gridStyle: gridStyles,
    renderCellPopover: renderCellPopover
  }));
};
exports.EventLogDataGrid = EventLogDataGrid;