"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseViewNavigation = void 0;
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_APP_ID = 'cases';
const generateCaseViewPath = caseId => {
  return (0, _reactRouterDom.generatePath)('/:caseId', {
    caseId
  });
};
const useCaseViewNavigation = () => {
  const {
    application: {
      navigateToApp,
      currentAppId$
    }
  } = (0, _kibana.useKibana)().services;
  const appId = (0, _useObservable.default)(currentAppId$);
  const navigateToCaseView = (0, _react.useCallback)(pathParams => navigateToApp(appId !== null && appId !== void 0 ? appId : '', {
    deepLinkId: CASE_APP_ID,
    path: generateCaseViewPath(pathParams.caseId)
  }), [navigateToApp, appId]);
  return {
    navigateToCaseView
  };
};
exports.useCaseViewNavigation = useCaseViewNavigation;