"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECT_ALL_ALERTS = exports.SELECTED_ALERTS = exports.COLUMN_HEADER_ARIA_LABEL = exports.CLEAR_SELECTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECTED_ALERTS = (selectedAlertsFormatted, selectedAlerts) => _i18n.i18n.translate('xpack.triggersActionsUI.toolbar.bulkActions.selectedAlertsTitle', {
  values: {
    selectedAlertsFormatted,
    selectedAlerts
  },
  defaultMessage: 'Selected {selectedAlertsFormatted} {selectedAlerts, plural, =1 {alert} other {alerts}}'
});
exports.SELECTED_ALERTS = SELECTED_ALERTS;
const SELECT_ALL_ALERTS = (totalAlertsFormatted, totalAlerts) => _i18n.i18n.translate('xpack.triggersActionsUI.toolbar.bulkActions.selectAllAlertsTitle', {
  values: {
    totalAlertsFormatted,
    totalAlerts
  },
  defaultMessage: 'Select all {totalAlertsFormatted} {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.SELECT_ALL_ALERTS = SELECT_ALL_ALERTS;
const CLEAR_SELECTION = _i18n.i18n.translate('xpack.triggersActionsUI.toolbar.bulkActions.clearSelectionTitle', {
  defaultMessage: 'Clear selection'
});
exports.CLEAR_SELECTION = CLEAR_SELECTION;
const COLUMN_HEADER_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.bulkActions.columnHeader.AriaLabel', {
  defaultMessage: 'Select all rows'
});
exports.COLUMN_HEADER_ARIA_LABEL = COLUMN_HEADER_ARIA_LABEL;