"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionsRowCell = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _alerts_table_context = require("../../contexts/alerts_table_context");
var _types = require("../../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkActionsRowCellComponent = ({
  rowIndex
}) => {
  var _rowSelection$get;
  const {
    bulkActions: [{
      rowSelection
    }, updateSelectedRows]
  } = (0, _react.useContext)(_alerts_table_context.AlertsTableContext);
  const isChecked = rowSelection.has(rowIndex);
  const isLoading = isChecked && ((_rowSelection$get = rowSelection.get(rowIndex)) === null || _rowSelection$get === void 0 ? void 0 : _rowSelection$get.isLoading);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "row-loader"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: rowIndex.toString(),
    checked: isChecked,
    onChange: e => {
      if (e.target.checked) {
        updateSelectedRows({
          action: _types.BulkActionsVerbs.add,
          rowIndex
        });
      } else {
        updateSelectedRows({
          action: _types.BulkActionsVerbs.delete,
          rowIndex
        });
      }
    },
    "data-test-subj": "bulk-actions-row-cell"
  });
};
const BulkActionsRowCell = /*#__PURE__*/_react.default.memo(BulkActionsRowCellComponent);
exports.BulkActionsRowCell = BulkActionsRowCell;