"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryWidgetFullSize = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _alert_counts = require("./alert_counts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidgetFullSize = ({
  activeAlertCount,
  activeAlerts,
  chartProps: {
    theme,
    baseTheme,
    onBrushEnd
  },
  dateFormat,
  recoveredAlertCount,
  hideChart
}) => {
  const chartTheme = [theme, {
    chartPaddings: {
      top: 7
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    element: "div",
    "data-test-subj": "alertSummaryWidgetFullSize",
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_counts.AlertCounts, {
    activeAlertCount: activeAlertCount,
    recoveredAlertCount: recoveredAlertCount
  })), !hideChart && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertSummaryWidgetFullSizeChartContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', 170]
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: tooltip => (0, _moment.default)(tooltip.value).format(dateFormat || _constants.TOOLTIP_DATE_FORMAT)
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: _charts.Position.Right,
    theme: chartTheme,
    baseTheme: baseTheme,
    onBrushEnd: onBrushEnd,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    timeAxisLayerCount: 2,
    gridLine: {
      visible: true
    },
    style: {
      tickLine: {
        size: 0.0001,
        padding: 4
      },
      tickLabel: {
        alignment: {
          horizontal: _charts.Position.Left,
          vertical: _charts.Position.Bottom
        }
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    integersOnly: true,
    ticks: 4
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "right",
    position: _charts.Position.Right,
    gridLine: {
      visible: true
    },
    integersOnly: true,
    ticks: 4
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "Active",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['doc_count'],
    color: [_constants.ALL_ALERT_COLOR],
    data: activeAlerts,
    lineSeriesStyle: {
      line: {
        strokeWidth: 2
      },
      point: {
        visible: false
      }
    },
    curve: _charts.CurveType.CURVE_MONOTONE_X
  }))));
};
exports.AlertSummaryWidgetFullSize = AlertSummaryWidgetFullSize;