"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EncryptedFieldsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Callout = ({
  title,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "iInCircle",
    "data-test-subj": dataTestSubj,
    title: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const isEmpty = value => value != null || !isEmpty(value);
const getSecretFields = fields => Object.keys(fields).filter(fieldPath => fieldPath.includes('secrets')).reduce((filteredFields, path) => ({
  ...filteredFields,
  [path]: fields[path]
}), {});
const getLabelsFromFields = fields => Object.keys(fields).map(fieldPath => fields[fieldPath].label).filter(isEmpty);
const getCommaSeparatedLabel = labels => {
  if (labels.length === 0) {
    return '';
  }
  if (labels.length === 1) {
    return `${labels[0]}`;
  }
  if (labels.length === 2) {
    return labels.join(' and ');
  }
  const lastLabel = labels[labels.length - 1];
  const commaSeparatedLabelsWithoutLastItem = labels.slice(0, -1).join(', ');
  return `${commaSeparatedLabelsWithoutLastItem}, and ${lastLabel}`;
};
const EncryptedFieldsCalloutComponent = ({
  isEdit,
  isMissingSecrets
}) => {
  /**
   * This is needed to rerender on any form change
   * and listen to any form field changes.
   */
  const [_] = (0, _hook_form_lib.useFormData)();
  const {
    getFields
  } = (0, _hook_form_lib.useFormContext)();
  const allFields = getFields();
  const secretFields = getSecretFields(allFields);
  const totalSecretFields = Object.keys(secretFields).length;
  const secretFieldsLabel = getCommaSeparatedLabel(getLabelsFromFields(secretFields));
  if (Object.keys(secretFields).length === 0) {
    return null;
  }
  if (isMissingSecrets) {
    return /*#__PURE__*/_react.default.createElement(Callout, {
      title: _i18n.i18n.translate('xpack.triggersActionsUI.components.builtinActionTypes.missingSecretsValuesLabel', {
        values: {
          secretFieldsLabel,
          encryptedFieldsLength: totalSecretFields
        },
        defaultMessage: 'Sensitive information is not imported. Please enter value{encryptedFieldsLength, plural, one {} other {s}} for the following field{encryptedFieldsLength, plural, one {} other {s}} {secretFieldsLabel}.'
      }),
      dataTestSubj: "missing-secrets-callout"
    });
  }
  if (!isEdit) {
    return /*#__PURE__*/_react.default.createElement(Callout, {
      title: _i18n.i18n.translate('xpack.triggersActionsUI.components.simpleConnectorForm.secrets.reenterValuesLabel', {
        values: {
          secretFieldsLabel,
          encryptedFieldsLength: totalSecretFields
        },
        defaultMessage: 'Remember your {secretFieldsLabel} {encryptedFieldsLength, plural, one {value} other {values}}. You must reenter {encryptedFieldsLength, plural, one {it} other {them}} each time you edit the connector.'
      }),
      dataTestSubj: "create-connector-secrets-callout"
    });
  }
  if (isEdit) {
    return /*#__PURE__*/_react.default.createElement(Callout, {
      title: _i18n.i18n.translate('xpack.triggersActionsUI.components.simpleConnectorForm.secrets.reenterValuesMessage', {
        values: {
          secretFieldsLabel,
          encryptedFieldsLength: totalSecretFields
        },
        defaultMessage: 'Value{encryptedFieldsLength, plural, one {} other {s}} {secretFieldsLabel} {encryptedFieldsLength, plural, one {is} other {are}} encrypted. Please reenter value{encryptedFieldsLength, plural, one {} other {s}} for {encryptedFieldsLength, plural, one {this} other {these}} field{encryptedFieldsLength, plural, one {} other {s}}.'
      }),
      dataTestSubj: "edit-connector-secrets-callout"
    });
  }
  return null;
};
const EncryptedFieldsCallout = /*#__PURE__*/(0, _react.memo)(EncryptedFieldsCalloutComponent);
exports.EncryptedFieldsCallout = EncryptedFieldsCallout;