"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _action_connector_api = require("../../lib/action_connector_api");
var _action_type_compare = require("../../lib/action_type_compare");
var _check_action_type_enabled = require("../../lib/check_action_type_enabled");
var _kibana = require("../../../common/lib/kibana");
var _section_loading = require("../../components/section_loading");
var _beta_badge_props = require("./beta_badge_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionTypeMenu = ({
  onActionTypeChange,
  featureId,
  setHasActionsUpgradeableByTrial,
  setAllActionTypes,
  actionTypeRegistry
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [loadingActionTypes, setLoadingActionTypes] = (0, _react.useState)(false);
  const [actionTypesIndex, setActionTypesIndex] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setLoadingActionTypes(true);
        const availableActionTypes = await (0, _action_connector_api.loadActionTypes)({
          http,
          featureId
        });
        setLoadingActionTypes(false);
        const index = {};
        for (const actionTypeItem of availableActionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setActionTypesIndex(index);
        if (setAllActionTypes) {
          setAllActionTypes(index);
        }
        // determine if there are actions disabled by license that that
        // would be enabled by upgrading to gold or trial
        if (setHasActionsUpgradeableByTrial) {
          const hasActionsUpgradeableByTrial = availableActionTypes.some(action => !index[action.id].enabledInLicense && index[action.id].minimumLicenseRequired === 'gold');
          setHasActionsUpgradeableByTrial(hasActionsUpgradeableByTrial);
        }
      } catch (e) {
        if (toasts) {
          toasts.addDanger({
            title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
              defaultMessage: 'Unable to load connector types'
            })
          });
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const registeredActionTypes = Object.entries(actionTypesIndex !== null && actionTypesIndex !== void 0 ? actionTypesIndex : []).filter(([id, details]) => actionTypeRegistry.has(id) && details.enabledInConfig === true && !actionTypeRegistry.get(id).hideInUi).map(([id, actionType]) => {
    const actionTypeModel = actionTypeRegistry.get(id);
    return {
      iconClass: actionTypeModel ? actionTypeModel.iconClass : '',
      selectMessage: actionTypeModel ? actionTypeModel.selectMessage : '',
      actionType,
      name: actionType.name,
      isExperimental: actionTypeModel.isExperimental
    };
  });
  const cardNodes = registeredActionTypes.sort((a, b) => (0, _action_type_compare.actionTypeCompare)(a.actionType, b.actionType)).map((item, index) => {
    const checkEnabledResult = (0, _check_action_type_enabled.checkActionTypeEnabled)(item.actionType);
    const card = /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      betaBadgeProps: item.isExperimental ? _beta_badge_props.betaBadgeProps : undefined,
      titleSize: "xs",
      "data-test-subj": `${item.actionType.id}-card`,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "xl",
        type: item.iconClass
      }),
      title: item.name,
      description: item.selectMessage,
      isDisabled: !checkEnabledResult.isEnabled,
      onClick: () => {
        onActionTypeChange(item.actionType);
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index
    }, checkEnabledResult.isEnabled && card, checkEnabledResult.isEnabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: checkEnabledResult.message
    }, card));
  });
  return loadingActionTypes ? /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.loadingConnectorTypesDescription",
    defaultMessage: "Loading connector types\u2026"
  })) : /*#__PURE__*/_react.default.createElement("div", {
    className: "actConnectorsListGrid"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "xl",
    columns: 3
  }, cardNodes));
};
exports.ActionTypeMenu = ActionTypeMenu;