"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runRule = runRule;
var _i18n = require("@kbn/i18n");
var _run_soon = require("./rule_api/run_soon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runRule(http, toasts, id) {
  try {
    const message = await (0, _run_soon.runSoon)({
      http,
      id
    });
    if (message) {
      toasts.addWarning({
        title: message
      });
    } else {
      toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ableToRunRuleSoon', {
          defaultMessage: 'Your rule is scheduled to run'
        })
      });
    }
  } catch (e) {
    toasts.addError(e, {
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToRunRuleSoon', {
        defaultMessage: 'Unable to schedule your rule to run'
      })
    });
  }
}