"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO (Jiawei): Use node builder instead of strings
const getFilter = ({
  message,
  outcomeFilter,
  runId,
  ruleTypeIds
}) => {
  const filter = [];
  if (message) {
    const escapedMessage = message.replace(/([\)\(\<\>\}\{\"\:\\])/gm, '\\$&');
    filter.push(`(message: "${escapedMessage}" OR error.message: "${escapedMessage}")`);
  }
  if (outcomeFilter && outcomeFilter.length) {
    const outcomeFilterKQL = getOutcomeFilter(outcomeFilter);
    if (outcomeFilterKQL) {
      filter.push(`(${outcomeFilterKQL})`);
    }
  }
  if (runId) {
    filter.push(`kibana.alert.rule.execution.uuid: ${runId}`);
  }
  if (ruleTypeIds !== null && ruleTypeIds !== void 0 && ruleTypeIds.length) {
    filter.push(`kibana.alert.rule.rule_type_id:(${ruleTypeIds.join(' or ')})`);
  }
  return filter;
};
exports.getFilter = getFilter;
function getOutcomeFilter(outcomeFilter) {
  const filterMapping = {
    failure: 'event.outcome: failure',
    warning: 'kibana.alerting.outcome: warning',
    success: 'kibana.alerting.outcome:success OR (event.outcome: success AND NOT kibana.alerting.outcome:*)',
    unknown: 'event.outcome: unknown'
  };
  return `${outcomeFilter.map(f => filterMapping[f]).join(' OR ')}`;
}