"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertingSectionBreadcrumb = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertingSectionBreadcrumb = (type, returnHref = false) => {
  // Home and sections
  switch (type) {
    case 'logs':
      return {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.logs.breadcrumbTitle', {
          defaultMessage: 'Logs'
        }),
        ...(returnHref ? {
          href: `${_constants.routeToLogs}`
        } : {})
      };
    case 'connectors':
      return {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.connectors.breadcrumbTitle', {
          defaultMessage: 'Connectors'
        }),
        ...(returnHref ? {
          href: `${_constants.routeToConnectors}`
        } : {})
      };
    case 'rules':
      return {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.rules.breadcrumbTitle', {
          defaultMessage: 'Rules'
        }),
        ...(returnHref ? {
          href: `${_constants.routeToRules}`
        } : {})
      };
    default:
      return {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.home.breadcrumbTitle', {
          defaultMessage: 'Rules'
        }),
        ...(returnHref ? {
          href: `${_constants.routeToHome}`
        } : {})
      };
  }
};
exports.getAlertingSectionBreadcrumb = getAlertingSectionBreadcrumb;