"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionConnector = createActionConnector;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRequest = ({
  actionTypeId,
  ...res
}) => ({
  ...res,
  connector_type_id: actionTypeId
});
const rewriteBodyRes = ({
  connector_type_id: actionTypeId,
  is_preconfigured: isPreconfigured,
  is_deprecated: isDeprecated,
  is_missing_secrets: isMissingSecrets,
  is_system_action: isSystemAction,
  ...res
}) => ({
  ...res,
  actionTypeId,
  isPreconfigured,
  isDeprecated,
  isMissingSecrets,
  isSystemAction
});
async function createActionConnector({
  http,
  connector
}) {
  const res = await http.post(`${_constants.BASE_ACTION_API_PATH}/connector`, {
    body: JSON.stringify(rewriteBodyRequest(connector))
  });
  return rewriteBodyRes(res);
}