"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescription = void 0;
exports.useRuleTypeAadTemplateFields = useRuleTypeAadTemplateFields;
var _common = require("@kbn/rule-registry-plugin/common");
var _react = require("react");
var _ecs = require("@kbn/ecs");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDescription = (fieldName, ecsFlat) => {
  var _ecsField$description, _ecsField, _ecsField$description2, _ecsField2;
  let ecsField = ecsFlat[fieldName];
  if ((0, _lodash.isEmpty)((_ecsField$description = (_ecsField = ecsField) === null || _ecsField === void 0 ? void 0 : _ecsField.description) !== null && _ecsField$description !== void 0 ? _ecsField$description : '') && fieldName.includes('kibana.alert.')) {
    ecsField = ecsFlat[fieldName.replace('kibana.alert.', '')];
  }
  return (_ecsField$description2 = (_ecsField2 = ecsField) === null || _ecsField2 === void 0 ? void 0 : _ecsField2.description) !== null && _ecsField$description2 !== void 0 ? _ecsField$description2 : '';
};
exports.getDescription = getDescription;
async function loadRuleTypeAadTemplateFields({
  http,
  ruleTypeId
}) {
  if (!ruleTypeId || !http) return [];
  const fields = await http.get(`${_common.BASE_RAC_ALERTS_API_PATH}/aad_fields`, {
    query: {
      ruleTypeId
    }
  });
  return fields;
}
function useRuleTypeAadTemplateFields(http, ruleTypeId, enabled) {
  // Reimplement useQuery here; this hook is sometimes called in contexts without a QueryClientProvider
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [data, setData] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (enabled && data.length === 0 && ruleTypeId) {
      setIsLoading(true);
      loadRuleTypeAadTemplateFields({
        http,
        ruleTypeId
      }).then(res => {
        setData(res);
        setIsLoading(false);
      });
    }
  }, [data, enabled, http, ruleTypeId]);
  return (0, _react.useMemo)(() => ({
    isLoading,
    fields: data.map(d => ({
      name: d.name,
      description: getDescription(d.name, _ecs.EcsFlat)
    }))
  }), [data, isLoading]);
}