"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleAADFields = useRuleAADFields;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/rule-registry-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_AAD_FIELDS = [];
async function fetchAadFields({
  http,
  ruleTypeId
}) {
  if (!ruleTypeId) return EMPTY_AAD_FIELDS;
  const fields = await http.get(`${_common.BASE_RAC_ALERTS_API_PATH}/aad_fields`, {
    query: {
      ruleTypeId
    }
  });
  return fields;
}
function useRuleAADFields(ruleTypeId) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const queryAadFieldsFn = () => {
    return fetchAadFields({
      http,
      ruleTypeId
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.useRuleAADFields.errorMessage', {
      defaultMessage: 'Unable to load alert fields per rule type'
    }));
  };
  const {
    data: aadFields = EMPTY_AAD_FIELDS,
    isInitialLoading,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadAlertAadFieldsPerRuleType', ruleTypeId],
    queryFn: queryAadFieldsFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false,
    enabled: ruleTypeId !== undefined
  });
  return (0, _react.useMemo)(() => ({
    aadFields,
    loading: ruleTypeId === undefined ? false : isInitialLoading || isLoading
  }), [aadFields, isInitialLoading, isLoading, ruleTypeId]);
}