"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsQueryDelayTitle = exports.RulesSettingsQueryDelaySection = exports.RulesSettingsQueryDelayErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/alerting-plugin/common");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rules_settings_range = require("../rules_settings_range");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryDelayDescription = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.queryDelayDescription', {
  defaultMessage: 'Delay all rule queries to mitigate the impact of index refresh intervals on data availability.'
});
const queryDelayLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.queryDelayLabel', {
  defaultMessage: 'Query delay length (seconds)'
});
const RulesSettingsQueryDelayErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsQueryDelayErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.queryDelayErrorPromptTitle",
      defaultMessage: "Unable to load your query delay settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.queryDelayErrorPromptBody",
      defaultMessage: "There was an error loading your query delay settings. Contact your administrator for help"
    }))
  });
});
exports.RulesSettingsQueryDelayErrorPrompt = RulesSettingsQueryDelayErrorPrompt;
const RulesSettingsQueryDelayTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.queryDelayTitle",
    defaultMessage: "Query delay"
  })));
};
exports.RulesSettingsQueryDelayTitle = RulesSettingsQueryDelayTitle;
const RulesSettingsQueryDelaySection = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    onChange,
    settings,
    hasError,
    canShow,
    canWrite
  } = props;
  if (!canShow) {
    return null;
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(RulesSettingsQueryDelayErrorPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "rulesSettingsQueryDelaySection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RulesSettingsQueryDelayTitle, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, queryDelayDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_rules_settings_range.RulesSettingsRange, {
    "data-test-subj": "queryDelayRangeInput",
    min: _common.MIN_QUERY_DELAY,
    max: _common.MAX_QUERY_DELAY,
    value: settings.delay,
    onChange: e => onChange('delay', parseInt(e.currentTarget.value, 10)),
    label: queryDelayLabel,
    disabled: !canWrite
  }))));
});
exports.RulesSettingsQueryDelaySection = RulesSettingsQueryDelaySection;