"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MustacheTextFieldWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _text_field_with_message_variables = require("./text_field_with_message_variables");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MustacheTextFieldWrapper = ({
  field,
  euiFieldProps,
  idAria,
  ...rest
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    value,
    setValue
  } = field;
  const editAction = (0, _react.useCallback)((property, newValue) => {
    setValue(newValue);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_text_field_with_message_variables.TextFieldWithMessageVariables, (0, _extends2.default)({
    errors: errorMessage ? [errorMessage] : [],
    formRowProps: {
      describedByIds: idAria ? [idAria] : undefined,
      error: errorMessage,
      fullWidth: true,
      helpText: typeof field.helpText === 'function' ? field.helpText() : field.helpText,
      isInvalid,
      label: field.label,
      ...rest
    },
    index: 0,
    inputTargetValue: value,
    wrapField: true
  }, euiFieldProps, {
    editAction: editAction
  }));
};
exports.MustacheTextFieldWrapper = MustacheTextFieldWrapper;