"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetTransforms = resetTransforms;
var _transform = require("../../../../common/types/transform");
var _error_utils = require("../../utils/error_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resetTransforms(reqBody, ctx, response) {
  const {
    transformsInfo
  } = reqBody;
  const results = {};
  const esClient = (await ctx.core).elasticsearch.client;
  for (const transformInfo of transformsInfo) {
    const transformReset = {
      success: false
    };
    const transformId = transformInfo.id;
    try {
      try {
        await esClient.asCurrentUser.transform.resetTransform({
          transform_id: transformId
        });
        transformReset.success = true;
      } catch (resetTransformJobError) {
        transformReset.error = resetTransformJobError.meta.body.error;
        if (resetTransformJobError.statusCode === 403) {
          return response.forbidden();
        }
      }
      results[transformId] = {
        transformReset
      };
    } catch (e) {
      if ((0, _error_utils.isRequestTimeout)(e)) {
        return (0, _error_utils.fillResultsWithTimeouts)({
          results,
          id: transformInfo.id,
          items: transformsInfo,
          action: _transform.TRANSFORM_ACTIONS.RESET
        });
      }
      results[transformId] = {
        transformReset: {
          success: false,
          error: e.meta.body.error
        }
      };
    }
  }
  return results;
}