"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _reset_transforms = require("../../../../common/api_schemas/reset_transforms");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  license
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/reset_transforms Post reset transforms
   * @apiName ResetTransforms
   * @apiDescription resets transforms
   *
   * @apiSchema (body) resetTransformsRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('reset_transforms'),
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _reset_transforms.resetTransformsRequestSchema
      }
    }
  }, license.guardApiRoute(_route_handler.routeHandler));
}