"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformUpdateButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _errors = require("../../../../../../common/utils/errors");
var _hooks = require("../../../../hooks");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformUpdateButton = ({
  closeFlyout
}) => {
  const requestConfig = (0, _use_edit_transform_flyout.useEditTransformFlyout)('requestConfig');
  const isUpdateButtonDisabled = (0, _use_edit_transform_flyout.useEditTransformFlyout)('isUpdateButtonDisabled');
  const config = (0, _use_edit_transform_flyout.useEditTransformFlyout)('config');
  const {
    apiError
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('actions');
  const updateTransfrom = (0, _hooks.useUpdateTransform)(config.id, requestConfig);
  async function submitFormHandler() {
    apiError(undefined);
    updateTransfrom(undefined, {
      onError: error => apiError((0, _errors.getErrorMessage)(error)),
      onSuccess: () => closeFlyout()
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "transformEditFlyoutUpdateButton",
    onClick: submitFormHandler,
    fill: true,
    isDisabled: isUpdateButtonDisabled
  }, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutUpdateButtonText', {
    defaultMessage: 'Update'
  }));
};
exports.EditTransformUpdateButton = EditTransformUpdateButton;