"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopActionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../managed_transforms_callout/managed_transforms_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StopActionModal = ({
  closeModal,
  items,
  stopAndCloseModal
}) => {
  const hasManagedTransforms = (0, _react.useMemo)(() => items.some(t => (0, _managed_transforms_utils.isManagedTransform)(t)), [items]);
  const isBulkAction = items.length > 1;
  const bulkStopModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkStopModalTitle', {
    defaultMessage: 'Stop {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: items && items.length
    }
  });
  const stopModalTitle = _i18n.i18n.translate('xpack.transform.transformList.stopModalTitle', {
    defaultMessage: 'Stop {transformId}?',
    values: {
      transformId: items[0] && items[0].config.id
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "transformStopModal",
    title: isBulkAction === true ? bulkStopModalTitle : stopModalTitle,
    onCancel: closeModal,
    onConfirm: () => stopAndCloseModal(items),
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalStopButton', {
      defaultMessage: 'Stop'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "primary"
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: items.length,
    action: _i18n.i18n.translate('xpack.transform.transformList.stopManagedTransformsDescription', {
      defaultMessage: 'stopping'
    })
  }) : null);
};
exports.StopActionModal = StopActionModal;