"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyTransformConfigToDefineState = applyTransformConfigToDefineState;
var _lodash = require("lodash");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
var _transform = require("../../../../../../../common/types/transform");
var _common = require("../../../../../common");
var _pivot_aggs = require("../../../../../common/pivot_aggs");
var _constants = require("../../../../../../../common/constants");
var _use_latest_function_config = require("../hooks/use_latest_function_config");
var _use_pivot_config = require("../hooks/use_pivot_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function applyTransformConfigToDefineState(state, transformConfig, dataView) {
  var _transformConfig$sour;
  // apply runtime fields from both the index pattern and inline configurations
  state.runtimeMappings = (0, _mlRuntimeFieldUtils.getCombinedRuntimeMappings)(dataView, transformConfig === null || transformConfig === void 0 ? void 0 : (_transformConfig$sour = transformConfig.source) === null || _transformConfig$sour === void 0 ? void 0 : _transformConfig$sour.runtime_mappings);
  if (transformConfig === undefined) {
    return state;
  }
  if ((0, _transform.isPivotTransform)(transformConfig)) {
    state.transformFunction = _constants.TRANSFORM_FUNCTION.PIVOT;

    // apply the transform configuration to wizard DEFINE state
    // transform aggregations config to wizard state
    state.aggList = Object.keys(transformConfig.pivot.aggregations).reduce((aggList, aggName) => {
      const aggConfig = transformConfig.pivot.aggregations[aggName];
      aggList[aggName] = (0, _pivot_aggs.getAggConfigFromEsAgg)(aggConfig, aggName);
      return aggList;
    }, {});

    // transform group by config to wizard state
    state.groupByList = Object.keys(transformConfig.pivot.group_by).reduce((groupByList, groupByName) => {
      const groupByConfig = transformConfig.pivot.group_by[groupByName];
      const groupBy = Object.keys(groupByConfig)[0];
      groupByList[groupByName] = {
        agg: groupBy,
        aggName: groupByName,
        dropDownName: groupByName,
        ...groupByConfig[groupBy]
      };
      return groupByList;
    }, {});
    state.previewRequest = {
      pivot: transformConfig.pivot
    };
    state.validationStatus = (0, _use_pivot_config.validatePivotConfig)(transformConfig.pivot);
  }
  if ((0, _transform.isLatestTransform)(transformConfig)) {
    var _dataView$fields$find3, _dataView$fields$find4;
    state.transformFunction = _constants.TRANSFORM_FUNCTION.LATEST;
    state.latestConfig = {
      unique_key: transformConfig.latest.unique_key.map(v => {
        var _dataView$fields$find, _dataView$fields$find2;
        return {
          value: v,
          label: dataView ? (_dataView$fields$find = (_dataView$fields$find2 = dataView.fields.find(f => f.name === v)) === null || _dataView$fields$find2 === void 0 ? void 0 : _dataView$fields$find2.displayName) !== null && _dataView$fields$find !== void 0 ? _dataView$fields$find : v : v
        };
      }),
      sort: {
        value: transformConfig.latest.sort,
        label: dataView ? (_dataView$fields$find3 = (_dataView$fields$find4 = dataView.fields.find(f => f.name === transformConfig.latest.sort)) === null || _dataView$fields$find4 === void 0 ? void 0 : _dataView$fields$find4.displayName) !== null && _dataView$fields$find3 !== void 0 ? _dataView$fields$find3 : transformConfig.latest.sort : transformConfig.latest.sort
      }
    };
    state.previewRequest = {
      latest: transformConfig.latest
    };
    state.validationStatus = (0, _use_latest_function_config.validateLatestConfig)(transformConfig.latest);
  }

  // only apply the query from the transform config to wizard state if it's not the default query
  const query = transformConfig.source.query;
  if (query !== undefined && !(0, _lodash.isEqual)(query, _common.matchAllQuery)) {
    state.isAdvancedSourceEditorEnabled = true;
    state.searchQuery = query;
    state.sourceConfigUpdated = true;
  }

  // applying a transform config to wizard state will always result in a valid configuration
  state.valid = true;
  return state;
}