"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _popover_form = require("./popover_form");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _sub_aggs_section = require("./sub_aggs_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && !item.isValid());
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  const helperText = (0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && item.helperText && item.helperText();
  const isSubAggSupported = (0, _common.isPivotAggsConfigWithUiBase)(item) && item.isSubAggsSupported && ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) ? item.isValid() : true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "transform__AggregationLabel--text"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformAggregationEntryLabel"
  }, item.aggName)), helperText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate",
    "data-test-subj": "transformAggHelperText",
    style: {
      lineHeight: '20px'
    }
  }, helperText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.editAggAriaLabel', {
        defaultMessage: 'Edit aggregation'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": `transformAggregationEntryEditButton_${item.aggName}`
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false)
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformAggregationEntryDeleteButton"
  }))), isSubAggSupported && /*#__PURE__*/_react.default.createElement(_sub_aggs_section.SubAggsSection, {
    item: item
  }));
};
exports.AggLabelForm = AggLabelForm;