"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopTransforms = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../common/constants");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _components = require("../components");
var _use_refresh_transform_list = require("./use_refresh_transform_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopTransforms = () => {
  const {
    http,
    i18n: i18nStart,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const refreshTransformList = (0, _use_refresh_transform_list.useRefreshTransformList)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const mutation = (0, _reactQuery.useMutation)({
    mutationFn: reqBody => http.post((0, _constants.addInternalBasePath)('stop_transforms'), {
      body: JSON.stringify(reqBody),
      version: '1'
    }),
    onError: error => toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.transform.transformList.stopTransformResponseSchemaErrorMessage', {
        defaultMessage: 'An error occurred called the stop transforms request.'
      }),
      text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
        text: (0, _errors.getErrorMessage)(error)
      }), {
        theme,
        i18n: i18nStart
      })
    }),
    onSuccess: results => {
      for (const transformId in results) {
        // hasOwnProperty check to ensure only properties on object itself, and not its prototypes
        if (results.hasOwnProperty(transformId)) {
          if (!results[transformId].success) {
            toastNotifications.addDanger(_i18n.i18n.translate('xpack.transform.transformList.stopTransformErrorMessage', {
              defaultMessage: 'An error occurred stopping the data frame transform {transformId}',
              values: {
                transformId
              }
            }));
          }
        }
      }
      refreshTransformList();
    }
  });
  return mutation.mutate;
};
exports.useStopTransforms = useStopTransforms;