"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformPreviewDevConsoleStatement = exports.getIndexDevConsoleStatement = exports.INIT_MAX_COLUMNS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INIT_MAX_COLUMNS = 20;
exports.INIT_MAX_COLUMNS = INIT_MAX_COLUMNS;
const getTransformPreviewDevConsoleStatement = request => {
  return `POST _transform/_preview\n${JSON.stringify(request, null, 2)}\n`;
};
exports.getTransformPreviewDevConsoleStatement = getTransformPreviewDevConsoleStatement;
const getIndexDevConsoleStatement = (query, dataViewTitle) => {
  return `GET ${dataViewTitle}/_search\n${JSON.stringify({
    query
  }, null, 2)}\n`;
};
exports.getIndexDevConsoleStatement = getIndexDevConsoleStatement;