"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retentionPolicyMaxAgeInvalidErrorMessage = exports.pageSearchSizeInvalidErrorMessage = exports.numberRangeMinus1To100NotValidErrorMessage = exports.numberRange10To10000NotValidErrorMessage = exports.numberOfRetriesInvalidErrorMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const numberRangeMinus1To100NotValidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.numberGreaterThanOrEqualToNegativeOneNotValidErrorMessage', {
  defaultMessage: 'Number of retries needs to be between 0 and 100, or -1 for infinite retries.'
});
exports.numberRangeMinus1To100NotValidErrorMessage = numberRangeMinus1To100NotValidErrorMessage;
const numberRange10To10000NotValidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.numberRange10To10000NotValidErrorMessage', {
  defaultMessage: 'Value needs to be an integer between 10 and 10000.'
});
exports.numberRange10To10000NotValidErrorMessage = numberRange10To10000NotValidErrorMessage;
const pageSearchSizeInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.maxPageSearchSizeInvalidMessage', {
  defaultMessage: 'Maximum page search size needs to be an integer between 10 and 65536.'
});

// Retention policy max age validator
exports.pageSearchSizeInvalidErrorMessage = pageSearchSizeInvalidErrorMessage;
const retentionPolicyMaxAgeInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.retentionPolicyMaxAgeInvalidMessage', {
  defaultMessage: 'Invalid max age format. Minimum of 60s required.'
});

// xpack.transform.transformList.numberOfRetriesInvalidErrorMessage
exports.retentionPolicyMaxAgeInvalidErrorMessage = retentionPolicyMaxAgeInvalidErrorMessage;
const numberOfRetriesInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingsValidations.numberOfRetriesInvalidErrorMessage', {
  defaultMessage: 'Number of retries needs to be between 0 and 100, or -1 for infinite retries.'
});
exports.numberOfRetriesInvalidErrorMessage = numberOfRetriesInvalidErrorMessage;