"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformHealthRuleType = getTransformHealthRuleType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _alerts = require("../../../common/utils/alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
function getTransformHealthRuleType() {
  return {
    id: _common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH,
    description: _i18n.i18n.translate('xpack.transform.alertingRuleTypes.transformHealth.description', {
      defaultMessage: 'Alert when transforms experience operational issues.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return docLinks.links.transforms.alertingRules;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transform_health_rule_trigger')))),
    validate: ruleParams => {
      var _ruleParams$includeTr;
      const validationResult = {
        errors: {
          includeTransforms: new Array(),
          testsConfig: new Array()
        }
      };
      if (!((_ruleParams$includeTr = ruleParams.includeTransforms) !== null && _ruleParams$includeTr !== void 0 && _ruleParams$includeTr.length)) {
        validationResult.errors.includeTransforms.push(_i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.includeTransforms.errorMessage', {
          defaultMessage: 'At least one transform has to be selected'
        }));
      }
      const resultTestConfig = (0, _alerts.getResultTestConfig)(ruleParams.testsConfig);
      const allTestDisabled = Object.values(resultTestConfig).every(v => !v.enabled);
      if (allTestDisabled) {
        validationResult.errors.testsConfig.push(_i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.testsConfigTransforms.errorMessage', {
          defaultMessage: 'At least one health check has to be selected'
        }));
      }
      return validationResult;
    },
    requiresAppContext: false,
    defaultActionMessage: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.defaultActionMessage', {
      defaultMessage: `[\\{\\{rule.name\\}\\}] Transform health check result:
\\{\\{context.message\\}\\}
\\{\\{#context.results\\}\\}
  Transform ID: \\{\\{transform_id\\}\\}
  \\{\\{#description\\}\\}Transform description: \\{\\{description\\}\\}
  \\{\\{/description\\}\\}\\{\\{#transform_state\\}\\}Transform state: \\{\\{transform_state\\}\\}
  \\{\\{/transform_state\\}\\}\\{\\{#health_status\\}\\}Transform health status: \\{\\{health_status\\}\\}
  \\{\\{/health_status\\}\\}\\{\\{#issues\\}\\}Issue: \\{\\{issue\\}\\}
  Issue count: \\{\\{count\\}\\}
  \\{\\{#details\\}\\}Issue details: \\{\\{details\\}\\}
  \\{\\{/details\\}\\}\\{\\{#first_occurrence\\}\\}First occurrence: \\{\\{first_occurrence\\}\\}
  \\{\\{/first_occurrence\\}\\}
  \\{\\{/issues\\}\\}\\{\\{#failure_reason\\}\\}Failure reason: \\{\\{failure_reason\\}\\}
  \\{\\{/failure_reason\\}\\}\\{\\{#notification_message\\}\\}Notification message: \\{\\{notification_message\\}\\}
  \\{\\{/notification_message\\}\\}\\{\\{#node_name\\}\\}Node name: \\{\\{node_name\\}\\}
  \\{\\{/node_name\\}\\}\\{\\{#timestamp\\}\\}Timestamp: \\{\\{timestamp\\}\\}
  \\{\\{/timestamp\\}\\}
\\{\\{/context.results\\}\\}
`
    })
  };
}