"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertRuleManageContext = exports.TransformAlertFlyoutWrapper = exports.TransformAlertFlyout = exports.AlertRulesManageContext = void 0;
exports.useAlertRuleFlyout = useAlertRuleFlyout;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _app_dependencies = require("../app/app_dependencies");
var _common = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformAlertFlyout = ({
  initialAlert,
  ruleParams,
  onCloseFlyout,
  onSave
}) => {
  const {
    triggersActionsUi
  } = (0, _app_dependencies.useAppDependencies)();
  const AlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUi) return;
    const commonProps = {
      onClose: () => {
        onCloseFlyout();
      },
      onSave: async () => {
        if (onSave) {
          onSave();
        }
      }
    };
    if (initialAlert) {
      return triggersActionsUi.getEditRuleFlyout({
        ...commonProps,
        initialRule: {
          ...initialAlert,
          ruleTypeId: initialAlert.alertTypeId
        }
      });
    }
    return triggersActionsUi.getAddRuleFlyout({
      ...commonProps,
      consumer: 'stackAlerts',
      canChangeTrigger: false,
      ruleTypeId: _common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH,
      metadata: {},
      initialValues: {
        params: ruleParams
      }
    });
    // deps on id to avoid re-rendering on auto-refresh
  }, [triggersActionsUi, initialAlert, ruleParams, onCloseFlyout, onSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, AlertFlyout);
};
exports.TransformAlertFlyout = TransformAlertFlyout;
const getAlertRuleManageContext = (0, _lodash.memoize)(function () {
  const ruleState$ = new _rxjs.BehaviorSubject({
    editAlertRule: null,
    createAlertRule: null
  });
  return {
    editAlertRule$: ruleState$.pipe((0, _operators.pluck)('editAlertRule')),
    createAlertRule$: ruleState$.pipe((0, _operators.pluck)('createAlertRule')),
    setEditAlertRule: initialRule => {
      ruleState$.next({
        createAlertRule: null,
        editAlertRule: initialRule
      });
    },
    setCreateAlertRule: transformId => {
      ruleState$.next({
        createAlertRule: {
          includeTransforms: [transformId]
        },
        editAlertRule: null
      });
    },
    hideAlertFlyout: () => {
      ruleState$.next({
        createAlertRule: null,
        editAlertRule: null
      });
    }
  };
});
exports.getAlertRuleManageContext = getAlertRuleManageContext;
const AlertRulesManageContext = /*#__PURE__*/(0, _react.createContext)(getAlertRuleManageContext());
exports.AlertRulesManageContext = AlertRulesManageContext;
function useAlertRuleFlyout() {
  return (0, _react.useContext)(AlertRulesManageContext);
}
const TransformAlertFlyoutWrapper = () => {
  const {
    editAlertRule$,
    createAlertRule$,
    hideAlertFlyout
  } = useAlertRuleFlyout();
  const editAlertRule = (0, _useObservable.default)(editAlertRule$);
  const createAlertRule = (0, _useObservable.default)(createAlertRule$);
  return editAlertRule || createAlertRule ? /*#__PURE__*/_react.default.createElement(TransformAlertFlyout, {
    initialAlert: editAlertRule,
    ruleParams: createAlertRule,
    onCloseFlyout: hideAlertFlyout
  }) : null;
};
exports.TransformAlertFlyoutWrapper = TransformAlertFlyoutWrapper;