"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineEventsDetailsSchema = void 0;
var _zod = require("zod");
var _runtime_mappings = require("../model/runtime_mappings");
var _timeline_events_queries = require("../model/timeline_events_queries");
var _request_paginated = require("./request_paginated");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineEventsDetailsSchema = _request_paginated.requestPaginated.partial().extend({
  indexName: _zod.z.string(),
  eventId: _zod.z.string(),
  authFilter: _zod.z.object({}).optional(),
  runtimeMappings: _runtime_mappings.runtimeMappings,
  factoryQueryType: _zod.z.literal(_timeline_events_queries.TimelineEventsQueries.details)
});
exports.timelineEventsDetailsSchema = timelineEventsDetailsSchema;