"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pagination = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pagination = _zod.z.object({
  /** The activePage parameter defines the page of results you want to fetch */
  activePage: _zod.z.number(),
  /** The cursorStart parameter defines the start of the results to be displayed */
  cursorStart: _zod.z.number().optional(),
  /** The querySize parameter is the number of items to be returned */
  querySize: _zod.z.number()
}).passthrough().optional();
exports.pagination = pagination;