"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityContext = void 0;
var _react = require("react");
var _security_solution_context = require("../containers/security_solution_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSecurityContext = () => {
  const contextValue = (0, _react.useContext)(_security_solution_context.SecuritySolutionContext);
  if (!contextValue) {
    throw new Error('SecuritySolutionContext can only be used within SecuritySolutionContext provider');
  }
  return contextValue;
};
exports.useSecurityContext = useSecurityContext;