"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseGuard = void 0;
var _react = _interopRequireDefault(require("react"));
var _paywall = require("../components/paywall");
var _use_security_context = require("../hooks/use_security_context");
var _security_solution_plugin_template_wrapper = require("./security_solution_plugin_template_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseGuard = ({
  children
}) => {
  const {
    licenseService
  } = (0, _use_security_context.useSecurityContext)();
  if (licenseService.isEnterprise()) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_security_solution_plugin_template_wrapper.SecuritySolutionPluginTemplateWrapper, {
    isEmptyState: true
  }, /*#__PURE__*/_react.default.createElement(_paywall.Paywall, null));
};
exports.EnterpriseGuard = EnterpriseGuard;