"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskErrorSource = exports.EphemeralTaskRejectedDueToCapacityError = void 0;
exports.createSkipError = createSkipError;
exports.createTaskRunError = createTaskRunError;
exports.isEphemeralTaskRejectedDueToCapacityError = isEphemeralTaskRejectedDueToCapacityError;
exports.isRetryableError = isRetryableError;
exports.isSkipError = isSkipError;
exports.isUnrecoverableError = isUnrecoverableError;
exports.throwRetryableError = throwRetryableError;
exports.throwUnrecoverableError = throwUnrecoverableError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Unrecoverable
const CODE_UNRECOVERABLE = 'TaskManager/unrecoverable';
const CODE_RETRYABLE = 'TaskManager/retryable';
const CODE_SKIP = 'TaskManager/skip';
const code = Symbol('TaskManagerErrorCode');
const retry = Symbol('TaskManagerErrorRetry');
const source = Symbol('TaskManagerErrorSource');
let TaskErrorSource;
exports.TaskErrorSource = TaskErrorSource;
(function (TaskErrorSource) {
  TaskErrorSource["FRAMEWORK"] = "framework";
  TaskErrorSource["USER"] = "user";
})(TaskErrorSource || (exports.TaskErrorSource = TaskErrorSource = {}));
class EphemeralTaskRejectedDueToCapacityError extends Error {
  constructor(message, task) {
    super(message);
    (0, _defineProperty2.default)(this, "_task", void 0);
    this._task = task;
  }
  get task() {
    return this._task;
  }
}
exports.EphemeralTaskRejectedDueToCapacityError = EphemeralTaskRejectedDueToCapacityError;
function isTaskManagerError(error) {
  return Boolean(error && error[code]);
}
function isUnrecoverableError(error) {
  return isTaskManagerError(error) && error[code] === CODE_UNRECOVERABLE;
}
function throwUnrecoverableError(error, errorSource = TaskErrorSource.FRAMEWORK) {
  error[code] = CODE_UNRECOVERABLE;
  error[source] = errorSource;
  throw error;
}
function isRetryableError(error) {
  if (isTaskManagerError(error) && error[code] === CODE_RETRYABLE) {
    return error[retry];
  }
  return null;
}
function throwRetryableError(error, shouldRetry) {
  error[code] = CODE_RETRYABLE;
  error[retry] = shouldRetry;
  throw error;
}
function isSkipError(error) {
  if (isTaskManagerError(error) && error[code] === CODE_SKIP) {
    return true;
  }
  return false;
}
function createSkipError(error) {
  error[code] = CODE_SKIP;
  return error;
}
function createTaskRunError(error, errorSource = TaskErrorSource.FRAMEWORK) {
  error[source] = errorSource;
  return error;
}
function isEphemeralTaskRejectedDueToCapacityError(error) {
  return Boolean(error && error instanceof EphemeralTaskRejectedDueToCapacityError);
}