"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsHosts = getEsHosts;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEsHosts({
  cloud,
  config
}) {
  const cloudUrl = (cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) && (cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl);
  const cloudHosts = cloudUrl ? [cloudUrl] : undefined;
  if (cloudHosts && cloudHosts.length > 0) {
    return cloudHosts;
  }
  const flagHosts = config.hosts;
  if (flagHosts && flagHosts.length > 0) {
    return flagHosts;
  }
  return [];
}