"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllLocations = getAllLocations;
var _helpers = require("../routes/settings/private_locations/helpers");
var _get_private_locations = require("../routes/settings/private_locations/get_private_locations");
var _get_service_locations = require("./get_service_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAllLocations({
  syntheticsMonitorClient,
  savedObjectsClient,
  server
}) {
  try {
    const [{
      locations: privateLocations,
      agentPolicies
    }, {
      locations: publicLocations,
      throttling
    }] = await Promise.all([(0, _get_private_locations.getPrivateLocationsAndAgentPolicies)(savedObjectsClient, syntheticsMonitorClient), getServicePublicLocations(server, syntheticsMonitorClient)]);
    return {
      publicLocations,
      privateLocations,
      throttling,
      allLocations: [...publicLocations, ...(0, _helpers.toClientContract)({
        locations: privateLocations
      }, agentPolicies)]
    };
  } catch (e) {
    server.logger.error(e);
    return {
      publicLocations: [],
      privateLocations: [],
      allLocations: []
    };
  }
}
const getServicePublicLocations = async (server, syntheticsMonitorClient) => {
  if (!syntheticsMonitorClient.syntheticsService.isAllowed) {
    return {
      locations: []
    };
  }
  if (syntheticsMonitorClient.syntheticsService.locations.length === 0) {
    return await (0, _get_service_locations.getServiceLocations)(server);
  }
  return {
    locations: syntheticsMonitorClient.syntheticsService.locations,
    throttling: syntheticsMonitorClient.syntheticsService.throttling
  };
};