"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGeoProperty = exports.modelVersion1 = exports.SyntheticsPrivateLocationsAttributesCodecLegacy = exports.PrivateLocationAttributesCodecLegacy = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateLocationAttributesCodecLegacy = t.intersection([t.interface({
  label: t.string,
  id: t.string,
  agentPolicyId: t.string,
  concurrentMonitors: t.number
}), t.partial({
  tags: t.array(t.string),
  /* Empty Lat lon was accidentally saved as an empty string instead of undefined or null
   * Need a migration to fix */
  geo: t.interface({
    lat: t.union([t.string, t.number]),
    lon: t.union([t.string, t.number])
  })
})]);
exports.PrivateLocationAttributesCodecLegacy = PrivateLocationAttributesCodecLegacy;
const SyntheticsPrivateLocationsAttributesCodecLegacy = t.type({
  locations: t.array(PrivateLocationAttributesCodecLegacy)
});
exports.SyntheticsPrivateLocationsAttributesCodecLegacy = SyntheticsPrivateLocationsAttributesCodecLegacy;
const transformGeoProperty = privateLocationDoc => {
  const {
    locations
  } = privateLocationDoc.attributes;
  return {
    document: {
      ...privateLocationDoc,
      attributes: {
        locations: locations.map(location => {
          var _location$geo$lat, _location$geo, _location$geo$lon, _location$geo2;
          return {
            ...location,
            geo: {
              lat: Number((_location$geo$lat = (_location$geo = location.geo) === null || _location$geo === void 0 ? void 0 : _location$geo.lat) !== null && _location$geo$lat !== void 0 ? _location$geo$lat : 0),
              lon: Number((_location$geo$lon = (_location$geo2 = location.geo) === null || _location$geo2 === void 0 ? void 0 : _location$geo2.lon) !== null && _location$geo$lon !== void 0 ? _location$geo$lon : 0)
            },
            isServiceManaged: false
          };
        })
      }
    }
  };
};
exports.transformGeoProperty = transformGeoProperty;
const modelVersion1 = {
  changes: [{
    type: 'unsafe_transform',
    transformFn: transformGeoProperty
  }]
};
exports.modelVersion1 = modelVersion1;