"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorFilterFields = getMonitorFilterFields;
exports.getSyntheticsFilterDisplayValues = getSyntheticsFilterDisplayValues;
exports.getSyntheticsFilterKeyForLabel = getSyntheticsFilterKeyForLabel;
exports.valueToLabelWithEmptyCount = exports.monitorTypeKeyLabelMap = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _runtime_types = require("../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMonitorFilterFields() {
  return ['tags', 'locations', 'monitorTypes', 'projects', 'schedules'];
}
function getSyntheticsFilterDisplayValues(values, field, locations) {
  switch (field) {
    case 'monitorTypes':
      return values.map(({
        label,
        count
      }) => {
        var _monitorTypeKeyLabelM;
        return {
          label: (_monitorTypeKeyLabelM = monitorTypeKeyLabelMap[label]) !== null && _monitorTypeKeyLabelM !== void 0 ? _monitorTypeKeyLabelM : label,
          count
        };
      });
    case 'schedules':
      return values.map(({
        label,
        count
      }) => ({
        label: _i18n.i18n.translate('xpack.synthetics.monitorFilters.frequencyLabel', {
          defaultMessage: `Every {count} minutes`,
          values: {
            count: label
          }
        }),
        count
      }));
    case 'locations':
      return values.map(({
        label,
        count
      }) => {
        var _foundLocation$label;
        const foundLocation = locations.find(({
          id: locationId,
          label: locationLabel
        }) => label === locationId || label === locationLabel);
        return {
          label: (_foundLocation$label = foundLocation === null || foundLocation === void 0 ? void 0 : foundLocation.label) !== null && _foundLocation$label !== void 0 ? _foundLocation$label : label,
          count
        };
      });
    default:
      return values;
  }
}
function getSyntheticsFilterKeyForLabel(value, field) {
  var _invert$value;
  switch (field) {
    case 'monitorTypes':
      return (_invert$value = (0, _lodash.invert)(monitorTypeKeyLabelMap)[value]) !== null && _invert$value !== void 0 ? _invert$value : value;
    case 'schedules':
      return (value !== null && value !== void 0 ? value : '').replace(/\D/g, '');
    default:
      return value;
  }
}
const valueToLabelWithEmptyCount = value => {
  if (Array.isArray(value)) {
    return value.map(v => ({
      label: v,
      count: 0
    }));
  }
  return value ? [{
    label: value,
    count: 0
  }] : [];
};
exports.valueToLabelWithEmptyCount = valueToLabelWithEmptyCount;
const monitorTypeKeyLabelMap = {
  [_runtime_types.MonitorTypeEnum.BROWSER]: 'Journey / Page',
  [_runtime_types.MonitorTypeEnum.HTTP]: 'HTTP',
  [_runtime_types.MonitorTypeEnum.TCP]: 'TCP',
  [_runtime_types.MonitorTypeEnum.ICMP]: 'ICMP'
};
exports.monitorTypeKeyLabelMap = monitorTypeKeyLabelMap;