"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsSettingsContext = exports.SyntheticsSettingsContextProvider = exports.SyntheticsSettingsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  BASE_PATH
} = _constants.CONTEXT_DEFAULTS;
const {
  DATE_RANGE_START,
  DATE_RANGE_END
} = _constants.CLIENT_DEFAULTS;

/**
 * These are default values for the context. These defaults are typically
 * overwritten by the Synthetics App upon its invocation.
 */
const defaultContext = {
  basePath: BASE_PATH,
  dateRangeStart: DATE_RANGE_START,
  dateRangeEnd: DATE_RANGE_END,
  isApmAvailable: true,
  isInfraAvailable: true,
  isLogsAvailable: true,
  isDev: false,
  canSave: false
};
const SyntheticsSettingsContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
exports.SyntheticsSettingsContext = SyntheticsSettingsContext;
const SyntheticsSettingsContextProvider = ({
  children,
  ...props
}) => {
  var _application$capabili;
  const {
    basePath,
    isApmAvailable,
    isInfraAvailable,
    isLogsAvailable,
    commonlyUsedRanges,
    isDev
  } = props;
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const canSave = (_application$capabili = application === null || application === void 0 ? void 0 : application.capabilities.uptime.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const value = (0, _react.useMemo)(() => {
    return {
      canSave,
      isDev,
      basePath,
      isApmAvailable,
      isInfraAvailable,
      isLogsAvailable,
      commonlyUsedRanges,
      dateRangeStart: dateRangeStart !== null && dateRangeStart !== void 0 ? dateRangeStart : DATE_RANGE_START,
      dateRangeEnd: dateRangeEnd !== null && dateRangeEnd !== void 0 ? dateRangeEnd : DATE_RANGE_END
    };
  }, [canSave, isDev, basePath, isApmAvailable, isInfraAvailable, isLogsAvailable, dateRangeStart, dateRangeEnd, commonlyUsedRanges]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsSettingsContext.Provider, {
    value: value,
    children: children
  });
};
exports.SyntheticsSettingsContextProvider = SyntheticsSettingsContextProvider;
const useSyntheticsSettingsContext = () => (0, _react.useContext)(SyntheticsSettingsContext);
exports.useSyntheticsSettingsContext = useSyntheticsSettingsContext;