"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowMode = TestNowMode;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_run_once_errors = require("./hooks/use_run_once_errors");
var _browser_test_results = require("./browser/browser_test_results");
var _simple_test_results = require("./simple/simple_test_results");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TestNowMode({
  testRun,
  onDone,
  isPushing,
  serviceError,
  errors
}) {
  var _testRun$monitor$loca;
  const {
    hasBlockingError,
    blockingErrorTitle,
    blockingErrorMessage,
    expectPings
  } = (0, _use_run_once_errors.useRunOnceErrors)({
    testRunId: testRun.id,
    serviceError,
    errors: errors !== null && errors !== void 0 ? errors : [],
    locations: (_testRun$monitor$loca = testRun.monitor.locations) !== null && _testRun$monitor$loca !== void 0 ? _testRun$monitor$loca : []
  });
  (0, _react.useEffect)(() => {
    if (!isPushing && (!testRun.id || hasBlockingError)) {
      onDone(testRun.id);
    }
    // we don't need onDone as a dependency since it's a function
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [testRun.id, hasBlockingError, isPushing]);
  const isBrowserMonitor = testRun.monitor.type === 'browser';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true
  }, hasBlockingError && !isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: blockingErrorTitle,
    color: "danger",
    iconType: "warning"
  }, blockingErrorMessage) || null, testRun && !hasBlockingError && !isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: testRun.id
  }, isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_browser_test_results.BrowserTestRunResult, {
    expectPings: expectPings,
    onDone: onDone,
    testRunId: testRun.id
  }) : /*#__PURE__*/_react.default.createElement(_simple_test_results.SimpleTestResults, {
    expectPings: expectPings,
    onDone: onDone,
    testRunId: testRun.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
}