"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListTable = PingListTable;
exports.SpanWithMargin = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_ping_expanded = require("./use_ping_expanded");
var _formatting = require("../../../../utils/formatting");
var I18LABELS = _interopRequireWildcard(require("./translations"));
var _ping_status = require("./columns/ping_status");
var _ping_error = require("./columns/ping_error");
var _response_code = require("./columns/response_code");
var _expand_row = require("./columns/expand_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PingListTable({
  loading,
  error,
  pings,
  onChange
}) {
  const {
    expandedRows,
    setExpandedRows
  } = (0, _use_ping_expanded.useExpandedPingList)(pings);
  const hasStatus = pings.reduce((hasHttpStatus, currentPing) => {
    var _currentPing$http, _currentPing$http$res;
    return hasHttpStatus || !!((_currentPing$http = currentPing.http) !== null && _currentPing$http !== void 0 && (_currentPing$http$res = _currentPing$http.response) !== null && _currentPing$http$res !== void 0 && _currentPing$http$res.status_code);
  }, false);
  const hasError = pings.reduce((errorType, currentPing) => {
    var _currentPing$error;
    return errorType || !!((_currentPing$error = currentPing.error) !== null && _currentPing$error !== void 0 && _currentPing$error.type);
  }, false);
  const columns = [{
    field: 'monitor.status',
    name: I18LABELS.STATUS_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_ping_status.PingStatusColumn, {
      pingStatus: pingStatus,
      item: item
    })
  }, {
    align: 'left',
    field: 'observer.geo.name',
    name: I18LABELS.LOCATION_LABEL
  }, {
    align: 'right',
    field: 'monitor.ip',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.ipAddressColumnLabel', {
      defaultMessage: 'IP'
    })
  }, {
    align: 'center',
    field: 'monitor.duration.us',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.durationMsColumnLabel', {
      defaultMessage: 'Duration'
    }),
    render: duration => duration ? (0, _formatting.formatDuration)(duration) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "ping-list-duration-unavailable-tool-tip"
    }, '--')
  }, ...(hasError ? [{
    field: 'error.type',
    name: I18LABELS.ERROR_LABEL,
    width: '30%',
    render: (errorType, item) => /*#__PURE__*/_react.default.createElement(_ping_error.PingErrorCol, {
      ping: item,
      errorType: errorType
    })
  }] : []),
  // Only add this column is there is any status present in list
  ...(hasStatus ? [{
    field: 'http.response.status_code',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(SpanWithMargin, null, I18LABELS.RES_CODE_LABEL),
    render: statusCode => /*#__PURE__*/_react.default.createElement(_response_code.ResponseCodeColumn, {
      statusCode: statusCode
    })
  }] : []), {
    align: 'right',
    width: '24px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_expand_row.ExpandRowColumn, {
      item: item,
      expandedRows: expandedRows,
      setExpandedRows: setExpandedRows
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    isExpandable: true,
    hasActions: true,
    items: pings,
    itemId: "docId",
    itemIdToExpandedRowMap: expandedRows,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.synthetics.pingList.pingsLoadingMesssage', {
      defaultMessage: 'Loading history...'
    }) : _i18n.i18n.translate('xpack.synthetics.pingList.pingsUnavailableMessage', {
      defaultMessage: 'No history found'
    }),
    tableLayout: 'auto',
    onChange: onChange
  });
}
const SpanWithMargin = _styledComponents.default.span`
  margin-right: 16px;
`;
exports.SpanWithMargin = SpanWithMargin;