"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleTestResults = SimpleTestResults;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _browser_test_results = require("./browser_test_results");
var _kibana_service = require("../../../../../utils/kibana_service");
var _use_simple_run_once_monitors = require("../hooks/use_simple_run_once_monitors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SimpleTestResults({
  name,
  testRunId,
  expectPings,
  onDone
}) {
  const {
    summaryDocs,
    retriesExceeded
  } = (0, _use_simple_run_once_monitors.useSimpleRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (retriesExceeded) {
      _kibana_service.kibanaService.toasts.addDanger({
        text: _browser_test_results.FAILED_TO_SCHEDULE,
        title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.manualTestRun.failedTest.name",
          defaultMessage: "Manual test run failed for {name}",
          values: {
            name
          }
        }))
      }, {
        toastLifeTimeMs: 10000
      });
      onDone(testRunId);
    }
  }, [name, onDone, retriesExceeded, testRunId]);
  (0, _react.useEffect)(() => {
    if (summaryDocs) {
      if (summaryDocs.length >= expectPings) {
        onDone(testRunId);
      }
    }
  }, [testRunId, expectPings, summaryDocs, onDone]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}