"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuickFilters = () => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const [_, updateUrlParams] = (0, _hooks.useUrlParams)();
  const handleFilterUpdate = monitorStatus => {
    return () => {
      updateUrlParams({
        statusFilter: statusFilter !== monitorStatus ? monitorStatus : undefined
      });
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: statusFilter === 'up',
    onClick: handleFilterUpdate('up')
  }, UP_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: statusFilter === 'down',
    onClick: handleFilterUpdate('down')
  }, DOWN_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: statusFilter === 'disabled',
    onClick: handleFilterUpdate('disabled')
  }, DISABLED_LABEL));
};
exports.QuickFilters = QuickFilters;
const DOWN_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.down', {
  defaultMessage: 'Down'
});
const UP_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.up', {
  defaultMessage: 'Up'
});
const DISABLED_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.disabled', {
  defaultMessage: 'Disabled'
});