"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColor = exports.MetricItem = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _moment = _interopRequireDefault(require("moment"));
var _state = require("../../../../state");
var _hooks = require("../../../../hooks");
var _formatting = require("../../../../utils/formatting");
var _actions_popover = require("./actions_popover");
var _manual_test_runs = require("../../../../state/manual_test_runs");
var _metric_item_icon = require("./metric_item_icon");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColor = (theme, isEnabled, status) => {
  if (!isEnabled) {
    return theme.eui.euiColorLightestShade;
  }
  switch (status) {
    case 'down':
      return theme.eui.euiColorVis9_behindText;
    case 'up':
      return theme.eui.euiColorVis0_behindText;
    case 'unknown':
      return theme.eui.euiColorGhost;
    default:
      return theme.eui.euiColorVis0_behindText;
  }
};
exports.getColor = getColor;
const MetricItem = ({
  monitor,
  medianDuration,
  maxDuration,
  minDuration,
  avgDuration,
  data,
  onClick
}) => {
  var _monitor$location;
  const [isMouseOver, setIsMouseOver] = (0, _react.useState)(false);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const isErrorPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const locationName = (0, _hooks.useLocationName)(monitor);
  const {
    status,
    timestamp,
    ping,
    configIdByLocation
  } = (0, _hooks.useStatusByLocationOverview)({
    configId: monitor.configId,
    locationId: monitor.location.id
  });
  const theme = (0, _public.useTheme)();
  const testInProgress = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunInProgressSelector)(monitor.configId));
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${monitor.name}-metric-item`,
    style: {
      height: '160px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${monitor.name}-metric-item-${locationName}-${status}`,
    paddingSize: "none",
    onMouseOver: () => {
      if (!isMouseOver) {
        setIsMouseOver(true);
      }
    },
    onMouseLeave: () => {
      if (isErrorPopoverOpen) {
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      }
      if (isMouseOver) {
        setIsMouseOver(false);
      }
    },
    style: {
      height: '100%',
      overflow: 'hidden',
      position: 'relative'
    },
    title: (0, _moment.default)(timestamp).format('LLL')
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onElementClick: () => {
      if (testInProgress) {
        dispatch((0, _manual_test_runs.toggleTestNowFlyoutAction)(monitor.configId));
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      } else {
        dispatch((0, _manual_test_runs.hideTestNowFlyoutAction)());
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      }
      if (!testInProgress && locationName) {
        onClick({
          configId: monitor.configId,
          id: monitor.id,
          location: locationName,
          locationId: monitor.location.id
        });
      }
    },
    baseTheme: _charts.DARK_THEME,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: `${monitor.configId}-${(_monitor$location = monitor.location) === null || _monitor$location === void 0 ? void 0 : _monitor$location.id}`,
    data: [[{
      title: monitor.name,
      subtitle: locationName,
      value: medianDuration,
      trendShape: _charts.MetricTrendShape.Area,
      trend: data,
      extra: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        justifyContent: "flexEnd"
        // empty title to prevent default title from showing
        ,
        title: "",
        component: "span"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        component: "span"
      }, _i18n.i18n.translate('xpack.synthetics.overview.duration.label', {
        defaultMessage: 'Duration'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        component: "span"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        title: _i18n.i18n.translate('xpack.synthetics.overview.duration.description', {
          defaultMessage: 'Median duration of last 50 checks'
        }),
        content: _i18n.i18n.translate('xpack.synthetics.overview.duration.description.values', {
          defaultMessage: 'Avg: {avg}, Min: {min}, Max: {max}',
          values: {
            avg: (0, _formatting.formatDuration)(avgDuration, {
              noSpace: true
            }),
            min: (0, _formatting.formatDuration)(minDuration, {
              noSpace: true
            }),
            max: (0, _formatting.formatDuration)(maxDuration, {
              noSpace: true
            })
          }
        }),
        position: "top"
      }))),
      valueFormatter: d => (0, _formatting.formatDuration)(d),
      color: getColor(theme, monitor.isEnabled, status)
    }]]
  })), (isMouseOver || isPopoverOpen) && /*#__PURE__*/_react.default.createElement(_actions_popover.ActionsPopover, {
    monitor: monitor,
    isPopoverOpen: isPopoverOpen,
    setIsPopoverOpen: setIsPopoverOpen,
    position: "relative",
    locationId: monitor.location.id
  }), configIdByLocation && /*#__PURE__*/_react.default.createElement(_metric_item_icon.MetricItemIcon, {
    monitor: monitor,
    status: status,
    ping: ping,
    timestamp: timestamp,
    configIdByLocation: configIdByLocation
  })));
};
exports.MetricItem = MetricItem;