"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridItemsByGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _overview_loader = require("../overview_loader");
var _filter_fields = require("../../../../../utils/filters/filter_fields");
var _use_filters = require("../../../common/monitor_filters/use_filters");
var _grid_group_item = require("./grid_group_item");
var _runtime_types = require("../../../../../../../../common/runtime_types");
var _state = require("../../../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GridItemsByGroup = ({
  loaded,
  currentMonitors,
  setFlyoutConfigCallback
}) => {
  const [fullScreenGroup, setFullScreenGroup] = (0, _react.useState)('');
  const {
    groupBy: {
      field: groupField,
      order: groupOrder
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const {
    locations: allLocations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const data = (0, _use_filters.useFilters)();
  if (!data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const {
    monitorTypes,
    locations,
    projects,
    tags
  } = data;
  let selectedGroup = {
    key: 'location',
    items: locations,
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(locations, 'locations', allLocations),
    otherValues: {
      label: 'Without any location',
      items: currentMonitors.filter(monitor => (0, _lodash.get)(monitor, 'locations', []).length === 0)
    }
  };
  switch (groupField) {
    case _runtime_types.ConfigKey.MONITOR_TYPE:
      selectedGroup = {
        key: _runtime_types.ConfigKey.MONITOR_TYPE,
        items: monitorTypes,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(monitorTypes, 'monitorTypes', allLocations),
        otherValues: {
          label: 'Invalid monitor type',
          items: currentMonitors.filter(monitor => !(0, _lodash.get)(monitor, _runtime_types.ConfigKey.MONITOR_TYPE))
        }
      };
      break;
    case 'locationId':
      selectedGroup = {
        key: 'location.label',
        items: locations,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(locations, 'locations', allLocations),
        otherValues: {
          label: 'Without any location',
          items: currentMonitors.filter(monitor => !(0, _lodash.get)(monitor, 'location'))
        }
      };
      break;
    case _runtime_types.ConfigKey.TAGS:
      selectedGroup = {
        key: _runtime_types.ConfigKey.TAGS,
        items: tags,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(tags, 'tags', allLocations),
        otherValues: {
          label: 'Without any tags',
          items: currentMonitors.filter(monitor => (0, _lodash.get)(monitor, 'tags', []).length === 0)
        }
      };
      break;
    case _runtime_types.ConfigKey.PROJECT_ID:
      selectedGroup = {
        key: 'projectId',
        items: projects,
        values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(projects, 'projects', allLocations),
        otherValues: {
          label: 'UI Monitors',
          items: currentMonitors.filter(monitor => !Boolean(monitor.projectId))
        }
      };
      break;
    default:
  }
  const selectedValues = (0, _lodash.orderBy)(selectedGroup.values, 'label', groupOrder !== null && groupOrder !== void 0 ? groupOrder : 'asc');
  if (monitorTypes.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedValues.map(groupItem => {
    const filteredMonitors = currentMonitors.filter(monitor => {
      const value = (0, _lodash.get)(monitor, selectedGroup.key);
      if (Array.isArray(value)) {
        return value.includes(groupItem.label);
      }
      if (selectedGroup.key === _runtime_types.ConfigKey.MONITOR_TYPE) {
        const typeKey = (0, _lodash.invert)(_filter_fields.monitorTypeKeyLabelMap)[groupItem.label];
        return (0, _lodash.get)(monitor, selectedGroup.key) === typeKey;
      }
      return (0, _lodash.get)(monitor, selectedGroup.key) === groupItem.label;
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedPanel, {
      isFullScreen: fullScreenGroup === groupItem.label
    }, /*#__PURE__*/_react.default.createElement(_grid_group_item.GroupGridItem, {
      groupLabel: groupItem.label,
      groupMonitors: filteredMonitors,
      loaded: loaded,
      setFlyoutConfigCallback: setFlyoutConfigCallback,
      setFullScreenGroup: setFullScreenGroup,
      fullScreenGroup: fullScreenGroup
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }), selectedGroup.otherValues.items.length > 0 && /*#__PURE__*/_react.default.createElement(WrappedPanel, {
    isFullScreen: fullScreenGroup === selectedGroup.otherValues.label
  }, /*#__PURE__*/_react.default.createElement(_grid_group_item.GroupGridItem, {
    groupLabel: selectedGroup.otherValues.label,
    groupMonitors: selectedGroup.otherValues.items,
    loaded: loaded,
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    setFullScreenGroup: setFullScreenGroup,
    fullScreenGroup: fullScreenGroup
  })));
};
exports.GridItemsByGroup = GridItemsByGroup;
const WrappedPanel = ({
  isFullScreen,
  children
}) => {
  const ref = (0, _react.useRef)(null);
  if (!isFullScreen) {
    return /*#__PURE__*/_react.default.createElement(StyledPanel, {
      hasShadow: false,
      hasBorder: true
    }, children);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(FullScreenPanel, {
    hasShadow: false,
    hasBorder: true
  }, children))));
};
const StyledPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  &&& {
    .fullScreenButton {
      visibility: hidden;
    }
    :hover {
      .fullScreenButton {
        visibility: visible;
      }
    }
  }
`;
const FullScreenPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  &&& {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
  }
`;