"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRecordRangeLabel = exports.getMonitorEnabledUpdateFailureMessage = exports.getMonitorEnabledSuccessLabel = exports.getMonitorDisabledSuccessLabel = exports.getFrequencyLabel = exports.getFilterForTypeMessage = exports.YES_LABEL = exports.NO_MONITOR_ITEM_SELECTED = exports.NO_LABEL = exports.NO_DATA_MESSAGE = exports.MONITOR_DELETE_SUCCESS_LABEL = exports.MONITOR_DELETE_LOADING_LABEL = exports.MONITOR_DELETE_FAILURE_LABEL = exports.LOADING = exports.EXPAND_TAGS_LABEL = exports.ENABLE_STATUS_ALERT = exports.ENABLE_MONITOR_LABEL = exports.ENABLE_LABEL = exports.EDIT_LABEL = exports.DUPLICATE_LABEL = exports.DISABLE_STATUS_ALERT = exports.DISABLE_MONITOR_LABEL = exports.DISABLE_LABEL = exports.DELETE_MONITOR_LABEL = exports.DELETE_LABEL = exports.DELETE_DESCRIPTION_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _runtime_types = require("../../../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_MONITOR_ITEM_SELECTED = _i18n.i18n.translate('xpack.synthetics.management.monitorList.noItemForSelectedFiltersMessage', {
  defaultMessage: 'No monitors found for selected filter criteria',
  description: 'This message is shown if there are no monitors in the table and some filter or search criteria exists'
});
exports.NO_MONITOR_ITEM_SELECTED = NO_MONITOR_ITEM_SELECTED;
const LOADING = _i18n.i18n.translate('xpack.synthetics.management.monitorList.loading', {
  defaultMessage: 'Loading...',
  description: 'Shown when the monitor list is waiting for a server response'
});
exports.LOADING = LOADING;
const NO_DATA_MESSAGE = _i18n.i18n.translate('xpack.synthetics.management.monitorList.noItemMessage', {
  defaultMessage: 'No monitors found',
  description: 'This message is shown if the monitors table is rendered but has no items.'
});
exports.NO_DATA_MESSAGE = NO_DATA_MESSAGE;
const EXPAND_TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags.expand', {
  defaultMessage: 'Click to view remaining tags'
});
exports.EXPAND_TAGS_LABEL = EXPAND_TAGS_LABEL;
const EDIT_LABEL = _i18n.i18n.translate('xpack.synthetics.management.editLabel', {
  defaultMessage: 'Edit'
});
exports.EDIT_LABEL = EDIT_LABEL;
const ENABLE_STATUS_ALERT = _i18n.i18n.translate('xpack.synthetics.management.enableStatusAlert', {
  defaultMessage: 'Enable status alerts'
});
exports.ENABLE_STATUS_ALERT = ENABLE_STATUS_ALERT;
const DISABLE_STATUS_ALERT = _i18n.i18n.translate('xpack.synthetics.management.disableStatusAlert', {
  defaultMessage: 'Disable status alerts'
});
exports.DISABLE_STATUS_ALERT = DISABLE_STATUS_ALERT;
const DUPLICATE_LABEL = _i18n.i18n.translate('xpack.synthetics.management.duplicateLabel', {
  defaultMessage: 'Duplicate'
});
exports.DUPLICATE_LABEL = DUPLICATE_LABEL;
const DISABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.management.disableLabel', {
  defaultMessage: 'Disable'
});
exports.DISABLE_LABEL = DISABLE_LABEL;
const ENABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.management.enableLabel', {
  defaultMessage: 'Enable'
});
exports.ENABLE_LABEL = ENABLE_LABEL;
const DELETE_LABEL = _i18n.i18n.translate('xpack.synthetics.management.deleteLabel', {
  defaultMessage: 'Delete'
});
exports.DELETE_LABEL = DELETE_LABEL;
const DELETE_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.synthetics.management.confirmDescriptionLabel', {
  defaultMessage: 'This action will delete the monitor but keep any data collected. This action cannot be undone.'
});
exports.DELETE_DESCRIPTION_LABEL = DELETE_DESCRIPTION_LABEL;
const YES_LABEL = _i18n.i18n.translate('xpack.synthetics.management.yesLabel', {
  defaultMessage: 'Delete'
});
exports.YES_LABEL = YES_LABEL;
const NO_LABEL = _i18n.i18n.translate('xpack.synthetics.management.noLabel', {
  defaultMessage: 'Cancel'
});
exports.NO_LABEL = NO_LABEL;
const DELETE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.management.deleteMonitorLabel', {
  defaultMessage: 'Delete monitor'
});
exports.DELETE_MONITOR_LABEL = DELETE_MONITOR_LABEL;
const MONITOR_DELETE_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorDeleteSuccessMessage', {
  defaultMessage: 'Monitor deleted successfully.'
});
exports.MONITOR_DELETE_SUCCESS_LABEL = MONITOR_DELETE_SUCCESS_LABEL;
const MONITOR_DELETE_FAILURE_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorDeleteFailureMessage', {
  defaultMessage: 'Monitor was unable to be deleted. Please try again later.'
});
exports.MONITOR_DELETE_FAILURE_LABEL = MONITOR_DELETE_FAILURE_LABEL;
const MONITOR_DELETE_LOADING_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorDeleteLoadingMessage', {
  defaultMessage: 'Deleting monitor...'
});
exports.MONITOR_DELETE_LOADING_LABEL = MONITOR_DELETE_LOADING_LABEL;
const getRecordRangeLabel = ({
  rangeStart,
  rangeEnd,
  total
}) => {
  // If total is less than the end range, use total as end range.
  const availableEndRange = Math.min(rangeEnd, total);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.management.monitorList.recordRange",
    defaultMessage: "Showing {range} of {total} {monitorsLabel}",
    values: {
      range: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: rangeStart
      }), "-", /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: availableEndRange
      })),
      total: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: total
      }),
      monitorsLabel: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.synthetics.management.monitorList.configurationRangeLabel', {
        defaultMessage: '{monitorCount, plural, one {Configuration} other {Configurations}}',
        values: {
          monitorCount: total
        }
      }))
    }
  });
};
exports.getRecordRangeLabel = getRecordRangeLabel;
const getFrequencyLabel = schedule => {
  return schedule.unit === _runtime_types.ScheduleUnit.SECONDS ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequencyInSeconds', {
    description: 'Monitor frequency in seconds',
    defaultMessage: '{countSeconds, number} {countSeconds, plural, one {second} other {seconds}}',
    values: {
      countSeconds: Number(schedule.number)
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequencyInMinutes', {
    description: 'Monitor frequency in minutes',
    defaultMessage: '{countMinutes, number} {countMinutes, plural, one {minute} other {minutes}}',
    values: {
      countMinutes: Number(schedule.number)
    }
  }));
};
exports.getFrequencyLabel = getFrequencyLabel;
const ENABLE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.management.enableMonitorLabel', {
  defaultMessage: 'Enable monitor'
});
exports.ENABLE_MONITOR_LABEL = ENABLE_MONITOR_LABEL;
const DISABLE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.management.disableMonitorLabel', {
  defaultMessage: 'Disable monitor'
});
exports.DISABLE_MONITOR_LABEL = DISABLE_MONITOR_LABEL;
const getMonitorEnabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.management.monitorEnabledSuccessMessage', {
  defaultMessage: 'Monitor {name} enabled successfully.',
  values: {
    name
  }
});
exports.getMonitorEnabledSuccessLabel = getMonitorEnabledSuccessLabel;
const getMonitorDisabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.management.monitorDisabledSuccessMessage', {
  defaultMessage: 'Monitor {name} disabled successfully.',
  values: {
    name
  }
});
exports.getMonitorDisabledSuccessLabel = getMonitorDisabledSuccessLabel;
const getMonitorEnabledUpdateFailureMessage = name => _i18n.i18n.translate('xpack.synthetics.management.monitorEnabledUpdateFailureMessage', {
  defaultMessage: 'Unable to update monitor {name}.',
  values: {
    name
  }
});
exports.getMonitorEnabledUpdateFailureMessage = getMonitorEnabledUpdateFailureMessage;
const getFilterForTypeMessage = typeName => _i18n.i18n.translate('xpack.synthetics.management.filter.clickTypeMessage', {
  defaultMessage: 'Click to filter records for type {typeName}.',
  values: {
    typeName
  }
});
exports.getFilterForTypeMessage = getFilterForTypeMessage;