"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorListColumns = useMonitorListColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _use_capabilities = require("../../../../../../hooks/use_capabilities");
var _alert_config = require("../../../../../../../common/runtime_types/monitor_management/alert_config");
var _permissions = require("../../../common/components/permissions");
var _tag_badges = require("../../../common/components/tag_badges");
var _use_monitor_alert_enable = require("../../../../hooks/use_monitor_alert_enable");
var labels = _interopRequireWildcard(require("./labels"));
var _monitor_details_link = require("./monitor_details_link");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _monitor_type_badge = require("../../../common/components/monitor_type_badge");
var _monitor_enabled = require("./monitor_enabled");
var _monitor_locations = require("./monitor_locations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorListColumns({
  loading,
  overviewStatus,
  setMonitorPendingDeletion
}) {
  var _useKibana$services$a, _useKibana$services, _useKibana$services$a2, _overviewStatus$proje;
  const history = (0, _reactRouterDom.useHistory)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const {
    alertStatus,
    updateAlertEnabledState
  } = (0, _use_monitor_alert_enable.useMonitorAlertEnable)();
  const isActionLoading = fields => {
    return alertStatus(fields[_runtime_types.ConfigKey.CONFIG_ID]) === _public.FETCH_STATUS.LOADING;
  };
  const canUsePublicLocations = (_useKibana$services$a = (_useKibana$services = (0, _public2.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$a2 = _useKibana$services.application) === null || _useKibana$services$a2 === void 0 ? void 0 : _useKibana$services$a2.capabilities.uptime.elasticManagedLocationsEnabled) !== null && _useKibana$services$a !== void 0 ? _useKibana$services$a : true;
  const isPublicLocationsAllowed = fields => {
    const publicLocations = fields.locations.some(loc => loc.isServiceManaged);
    return publicLocations ? Boolean(canUsePublicLocations) : true;
  };
  const columns = [{
    align: 'left',
    field: _runtime_types.ConfigKey.NAME,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.monitorName', {
      defaultMessage: 'Monitor'
    }),
    sortable: true,
    render: (_, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_details_link.MonitorDetailsLink, {
      monitor: monitor
    })
  },
  // Only show Project ID column if project monitors are present
  ...(((_overviewStatus$proje = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.projectMonitorsCount) !== null && _overviewStatus$proje !== void 0 ? _overviewStatus$proje : 0 > 0) ? [{
    align: 'left',
    field: _runtime_types.ConfigKey.PROJECT_ID,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.projectId', {
      defaultMessage: 'Project ID'
    }),
    sortable: true
  }] : []), {
    align: 'left',
    field: _runtime_types.ConfigKey.MONITOR_TYPE,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.monitorType', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    render: (_, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
      monitor: monitor,
      ariaLabel: labels.getFilterForTypeMessage(monitor[_runtime_types.ConfigKey.MONITOR_TYPE]),
      onClick: () => {
        history.push({
          search: `monitorTypes=${encodeURIComponent(JSON.stringify([monitor[_runtime_types.ConfigKey.MONITOR_TYPE]]))}`
        });
      }
    })
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.SCHEDULE,
    sortable: true,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequency', {
      defaultMessage: 'Frequency'
    }),
    render: schedule => (0, labels.getFrequencyLabel)(schedule)
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.LOCATIONS,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations', {
      defaultMessage: 'Locations'
    }),
    render: (locations, monitor) => {
      var _monitor$ConfigKey$CO;
      return locations ? /*#__PURE__*/_react.default.createElement(_monitor_locations.MonitorLocations, {
        monitorId: (_monitor$ConfigKey$CO = monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : monitor.id,
        locations: locations,
        overviewStatus: overviewStatus
      }) : null;
    }
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.TAGS,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags', {
      defaultMessage: 'Tags'
    }),
    render: tags => /*#__PURE__*/_react.default.createElement(_tag_badges.TagsBadges, {
      tags: tags,
      onClick: tag => {
        history.push({
          search: `tags=${encodeURIComponent(JSON.stringify([tag]))}`
        });
      }
    })
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.ENABLED,
    sortable: true,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.enabled', {
      defaultMessage: 'Enabled'
    }),
    render: (_enabled, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_enabled.MonitorEnabled, {
      configId: monitor[_runtime_types.ConfigKey.CONFIG_ID],
      monitor: monitor,
      reloadPage: () => {},
      isSwitchable: !loading
    })
  }, {
    align: 'right',
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      'data-test-subj': 'syntheticsMonitorEditAction',
      isPrimary: true,
      name: fields => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        canUsePublicLocations: isPublicLocationsAllowed(fields)
      }, labels.EDIT_LABEL),
      description: labels.EDIT_LABEL,
      icon: 'pencil',
      type: 'icon',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields),
      onClick: fields => {
        history.push({
          pathname: `/edit-monitor/${fields[_runtime_types.ConfigKey.CONFIG_ID]}`
        });
      }
    }, {
      'data-test-subj': 'syntheticsMonitorDeleteAction',
      isPrimary: true,
      name: fields => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        canUsePublicLocations: isPublicLocationsAllowed(fields)
      }, labels.DELETE_LABEL),
      description: labels.DELETE_LABEL,
      icon: 'trash',
      type: 'icon',
      color: 'danger',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields),
      onClick: fields => {
        setMonitorPendingDeletion(fields);
      }
    }, {
      description: labels.DISABLE_STATUS_ALERT,
      name: fields => (0, _alert_config.isStatusEnabled)(fields[_runtime_types.ConfigKey.ALERT_CONFIG]) ? labels.DISABLE_STATUS_ALERT : labels.ENABLE_STATUS_ALERT,
      icon: fields => (0, _alert_config.isStatusEnabled)(fields[_runtime_types.ConfigKey.ALERT_CONFIG]) ? 'bellSlash' : 'bell',
      type: 'icon',
      color: 'danger',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields),
      onClick: fields => {
        updateAlertEnabledState({
          monitor: {
            [_runtime_types.ConfigKey.ALERT_CONFIG]: (0, _alert_config.toggleStatusAlert)(fields[_runtime_types.ConfigKey.ALERT_CONFIG])
          },
          name: fields[_runtime_types.ConfigKey.NAME],
          configId: fields[_runtime_types.ConfigKey.CONFIG_ID]
        });
      }
    }
    /*
    TODO: Implement duplication functionality
    const duplicateMenuItem = (
    <EuiContextMenuItem key="xpack.synthetics.duplicateMonitor" icon="copy" onClick={closePopover}>
      {labels.DUPLICATE_LABEL}
    </EuiContextMenuItem>
    );
    */]
  }];

  if (!canEditSynthetics) {
    // replace last column with a tooltip
    columns[columns.length - 1] = {
      align: 'right',
      name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.actions', {
        defaultMessage: 'Actions'
      }),
      render: () => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "syntheticsUseMonitorListColumnsButton",
        iconType: "boxesHorizontal",
        isDisabled: true,
        "aria-label": _permissions.CANNOT_PERFORM_ACTION_SYNTHETICS
      }))
    };
  }
  return columns;
}