"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunTestManually = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _permissions = require("../common/components/permissions");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _monitor_management = require("../../../../../common/constants/monitor_management");
var _run_test_btn = require("../monitor_add_edit/form/run_test_btn");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
var _manual_test_runs = require("../../state/manual_test_runs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RunTestManually = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const testInProgress = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunInProgressSelector)(monitor === null || monitor === void 0 ? void 0 : monitor.config_id));
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)(monitor === null || monitor === void 0 ? void 0 : monitor[_monitor_management.ConfigKey.LOCATIONS]);
  const content = !canUsePublicLocations ? _permissions.CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS : testInProgress ? _run_test_btn.TEST_SCHEDULED_LABEL : _run_test_btn.TEST_NOW_ARIA_LABEL;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: content,
    key: content
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsRunTestManuallyButton",
    color: "success",
    iconType: "beaker",
    isLoading: !Boolean(monitor) || testInProgress,
    isDisabled: !canUsePublicLocations,
    onClick: () => {
      if (monitor) {
        dispatch(_manual_test_runs.manualTestMonitorAction.get({
          configId: monitor.config_id,
          name: monitor.name
        }));
      }
    }
  }, RUN_TEST_LABEL));
};
exports.RunTestManually = RunTestManually;
const RUN_TEST_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorSummary.runTestManually', {
  defaultMessage: 'Run test manually'
});