"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorDetailsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _refresh_button = require("../common/components/refresh_button");
var _monitor_not_found_page = require("./monitor_not_found_page");
var _monitor_details_page_title = require("./monitor_details_page_title");
var _run_test_manually = require("./run_test_manually");
var _monitor_details_last_run = require("./monitor_details_last_run");
var _monitor_details_status = require("./monitor_details_status");
var _monitor_details_location = require("./monitor_details_location");
var _monitor_errors = require("./monitor_errors/monitor_errors");
var _errors_icon = require("./monitor_errors/errors_icon");
var _monitor_history = require("./monitor_history/monitor_history");
var _monitor_summary = require("./monitor_summary/monitor_summary");
var _edit_monitor_link = require("./monitor_summary/edit_monitor_link");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitorDetailsRoute = (history, syntheticsPath, baseTitle) => {
  return [{
    title: _i18n.i18n.translate('xpack.synthetics.monitorDetails.title', {
      defaultMessage: 'Synthetics Monitor Details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ROUTE,
    component: _monitor_summary.MonitorSummary,
    dataTestSubj: 'syntheticsMonitorDetailsPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'overview')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorHistory.title', {
      defaultMessage: 'Synthetics Monitor History | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_HISTORY_ROUTE,
    component: _monitor_history.MonitorHistory,
    dataTestSubj: 'syntheticsMonitorHistoryPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'history')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorErrors.title', {
      defaultMessage: 'Synthetics Monitor Errors | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ERRORS_ROUTE,
    component: _monitor_errors.MonitorErrors,
    dataTestSubj: 'syntheticsMonitorHistoryPage',
    pageHeader: getMonitorSummaryHeader(history, syntheticsPath, 'errors')
  }, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorNotFound.title', {
      defaultMessage: 'Synthetics Monitor Not Found | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_NOT_FOUND_ROUTE,
    component: _monitor_not_found_page.MonitorNotFoundPage,
    dataTestSubj: 'syntheticsMonitorNotFoundPage',
    pageHeader: {
      breadcrumbs: [getMonitorsBreadcrumb(syntheticsPath)]
    }
  }];
};
exports.getMonitorDetailsRoute = getMonitorDetailsRoute;
const getMonitorsBreadcrumb = syntheticsPath => ({
  text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "arrowLeft"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorSummaryRoute.monitorBreadcrumb",
    defaultMessage: "Monitors"
  })),
  color: 'primary',
  'aria-current': false,
  href: `${syntheticsPath}${_constants.MONITORS_ROUTE}`
});
const getMonitorSummaryHeader = (history, syntheticsPath, selectedTab) => {
  // Not a component, but it doesn't matter. Hooks are just functions
  const match = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE); // eslint-disable-line react-hooks/rules-of-hooks

  if (!match) {
    return {};
  }
  const search = history.location.search;
  const monitorId = match.params.monitorId;
  return {
    pageTitle: /*#__PURE__*/_react.default.createElement(_monitor_details_page_title.MonitorDetailsPageTitle, null),
    breadcrumbs: [getMonitorsBreadcrumb(syntheticsPath)],
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_refresh_button.RefreshButton, null), /*#__PURE__*/_react.default.createElement(_edit_monitor_link.EditMonitorLink, null), /*#__PURE__*/_react.default.createElement(_run_test_manually.RunTestManually, null), /*#__PURE__*/_react.default.createElement(_monitor_details_last_run.MonitorDetailsLastRun, null), /*#__PURE__*/_react.default.createElement(_monitor_details_status.MonitorDetailsStatus, null), /*#__PURE__*/_react.default.createElement(_monitor_details_location.MonitorDetailsLocation, null)],
    tabs: [{
      label: _i18n.i18n.translate('xpack.synthetics.monitorOverviewTab.title', {
        defaultMessage: 'Overview'
      }),
      isSelected: selectedTab === 'overview',
      href: `${syntheticsPath}${_constants.MONITOR_ROUTE.replace(':monitorId?', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorOverviewTab'
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.monitorHistoryTab.title', {
        defaultMessage: 'History'
      }),
      isSelected: selectedTab === 'history',
      href: `${syntheticsPath}${_constants.MONITOR_HISTORY_ROUTE.replace(':monitorId', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorHistoryTab'
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.monitorErrorsTab.title', {
        defaultMessage: 'Errors'
      }),
      prepend: /*#__PURE__*/_react.default.createElement(_errors_icon.MonitorErrorsIcon, null),
      isSelected: selectedTab === 'errors',
      href: `${syntheticsPath}${_constants.MONITOR_ERRORS_ROUTE.replace(':monitorId', monitorId)}${search}`,
      'data-test-subj': 'syntheticsMonitorErrorsTab'
    }]
  };
};